#ifndef DATA_H
#define DATA_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QSize>
#include <QtCore/QMutex>
#include <QtCore/QWaitCondition>
#include <QtGui/QImage>
#include <QtGui/QColor>

const int chunkLen = 50;
const double zWidth = 3.1;
const double zHeight = 3.1;

class Data : public QObject
{
  Q_OBJECT

  private:
    QImage *image;
    double c_a, c_b, c_x, c_y, c_re, c_im;
    int chunkCount, threadCount, frameCount, threadsReady;
    int maxFrames, imageWidth, imageHeight, maxIterations;
    QColor palette[1025];
    QString savePath;
    
  public:
    QMutex chunkMutex, frameMutex, movieMutex;
    QWaitCondition frameWait, movieWait;
    bool shutdownFlag;
    
  public:
    Data(QObject* parent=0);
    QImage * getImage();
    QSize getImageSize();
    void loadImage(QString fileName);
    void saveImage(QString fileName);
    void initPalette();
    QColor getPalette(int paletteIndex);
    void setThreadCount(int value);
    int getThreadCount();
    void setThreadsReady(int value);
    int getThreadsReady();
    void threadReady();
    void frameReady();
    void initChunks();
    int  getChunkCount();
    bool getNextChunk(int &start, int &len);
    void nextFrame();
    int getFrameCount();
    void setMovie(int p_maxFrames, int p_imageWidth, int p_imageHeight, int p_maxIterations);
    void setEllipse(double p_c_x, double p_c_y, double p_c_a, double p_c_b);
    void getC(double &p_c_re, double &p_c_im);
    int getMaxIterations();
    int getMaxFrames();
    void setSavePath(QString qs);
    void saveFrame();
    
  signals:
    void updateFrame();  
};
  
#endif
