#include <math.h>
#include "data.h"

Data::Data(QObject *parent) : QObject(parent) {

  image = new QImage(imageWidth, imageHeight, QImage::Format_RGB32);
  image->fill(0xA0A0A0);
  threadCount = 1;
  chunkCount = 0;
  shutdownFlag = false;
  initPalette();
}

Data::~Data() {
  
  delete image;
}

void Data::initPalette() {

  int i;
  
  for (i = 0; i <= maxIterations; i++) {
    palette[i] = QColor(128.0 + 127.0 * sin(3.0 + 21.0 * (double)i / (double)maxIterations),  
                        128.0 + 127.0 * sin(17.0 * (double)i / (double)maxIterations),  
                        128.0 + 127.0 * sin(53.0 * (double)i / (double)maxIterations));
  }
}

QColor Data::getPalette(int paletteIndex) {

  return(palette[paletteIndex]);
}

QImage * Data::getImage() {

  return(image);
}

QSize Data::getImageSize() {

  return(image->size());
}

void Data::saveImage(QString fileName) {

  image->save(fileName);
}

void Data::scaleImage(double scale) {

  QImage scaledImage = image->scaled((double)image->width() *  scale, (double)image->height() * scale, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
  *image = scaledImage;
} 

void Data::setThreadCount(int value) {

  threadCount = value;
}

int Data::getThreadCount() {

  return(threadCount);
}

void Data::calcChunks() { 

  chunkCount = (int)ceil((double)imageHeight / (double)chunkLen);
}

int Data::getChunkCount() {

  return(chunkCount);
}

bool Data::getNextChunk(int &start, int &len) { 

  bool ok;
  
  chunkMutex.lock();
  chunkCount--;
  start = chunkCount * chunkLen;
  len = (start > (imageHeight - chunkLen)) ? imageHeight - start : chunkLen;
  ok = start >= 0;
  chunkMutex.unlock();
  return(ok);
}
