/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;
import javax.crypto.Cipher;
import net.nieden.FileCrypter.CFileBlockProcessor;
import net.nieden.FileCrypter.CFileHeader;
import net.nieden.FileCrypter.CFileTools;
import net.nieden.FileCrypter.IFileProgressIndicator;

public class CFileDecrypter {
    private IFileProgressIndicator pgrsIndicator = null;
    private Cipher dcipher;
    private FileInputStream fis;
    private CFileHeader cfHeader;
    private String passwd;

    public CFileDecrypter(File file, String string) throws Exception {
        this.passwd = string;
        this.dcipher = CFileTools.initDecryption(this.passwd);
        this.fis = new FileInputStream(file);
        this.cfHeader = new CFileHeader(this.fis, this.dcipher, string);
    }

    public void processFile() throws Exception {
        this.processFile(false);
    }

    public void processFile(boolean bl) throws Exception {
        CFileBlockProcessor cFileBlockProcessor = null;
        File file = new File(String.format("DECRY_%012x.bin", new Date().getTime()));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (bl) {
            cFileBlockProcessor = new CFileBlockProcessor(this.cfHeader.blockCount, false, this.pgrsIndicator);
        }
        block0: for (int i = 0; i < this.cfHeader.blockCount; ++i) {
            int n;
            int n2 = 0;
            for (int j = 0; j < 4; ++j) {
                n = this.fis.read() & 0xFF;
                n2 |= n << (3 - j) * 8;
            }
            byte[] byArray = CFileTools.readFromInputStream(this.fis, n2);
            if (bl) {
                while (true) {
                    if ((n = cFileBlockProcessor.getWorkingThreadCount()) < cFileBlockProcessor.maxThreads) {
                        cFileBlockProcessor.blockProcThreadList.get(i).startWorking(byArray, this.cfHeader.compression, this.passwd, fileOutputStream);
                        continue block0;
                    }
                    Thread.sleep(100L);
                }
            }
            byte[] byArray2 = CFileTools.decryptBlock(this.dcipher, byArray);
            if (this.cfHeader.compression) {
                byte[] byArray3 = CFileTools.decompressBlock(byArray2);
                byArray2 = byArray3;
            }
            fileOutputStream.write(byArray2, 0, byArray2.length);
            if (this.pgrsIndicator == null) continue;
            this.pgrsIndicator.progressIndicator(i, this.cfHeader.blockCount);
        }
        this.fis.close();
        if (bl) {
            cFileBlockProcessor.waitForLastBlock();
        }
        fileOutputStream.close();
        File file2 = new File(this.cfHeader.originalFileName);
        if (!file2.exists()) {
            file.renameTo(file2);
        }
    }

    public void setProgressIndicator(IFileProgressIndicator iFileProgressIndicator) {
        this.pgrsIndicator = iFileProgressIndicator;
    }
}

