package net.nieden.FileCrypter;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.util.concurrent.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

public class CDirChooser implements ActionListener, TreeSelectionListener, MouseListener, WindowListener {
	protected JDialog jf=new JDialog((JFrame)null,"Select a directory", true);
	protected File rootDir;
	protected DefaultMutableTreeNode dmtRoot=new DefaultMutableTreeNode("/");
	protected JTree jt=new JTree(dmtRoot);
	protected JScrollPane jsp=new JScrollPane(jt,
		JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
		JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	protected Semaphore semClose=new Semaphore(1);
	protected JMenuItem jmiSelect, jmiClose;
	protected JPopupMenu popup=new JPopupMenu();
	protected boolean isClosed=false;
	protected String sPathSelected="";
	protected Image img=Toolkit.getDefaultToolkit().createImage("images/user-home.png");

	public CDirChooser(File d) throws Exception {
		if (!d.isDirectory()) throw new Exception(d+" is not a valid directory!");
		rootDir=d;
		buildGUI();
	}

	public String treePathToAbsolutePath(TreePath tp) {
		String s="";
		int n=tp.getPathCount();
		DefaultMutableTreeNode dmt=null;

		for (int i=1;i<n;i++) {
			dmt=(DefaultMutableTreeNode)tp.getPathComponent(i);
			if (i>1 && s.charAt(s.length()-1)!=File.separatorChar) s+=File.separatorChar;
			s+=(String)dmt.getUserObject();
		}
		return s;
	}

	public void showSubDirsOfPath(TreePath tp) {
		try {
			int n=tp.getPathCount();
			String s="";
			DefaultMutableTreeNode dmt=null;
			for (int i=1;i<n;i++) {
				dmt=(DefaultMutableTreeNode)tp.getPathComponent(i);
				if (i>1 && s.charAt(s.length()-1)!=File.separatorChar) s+=File.separatorChar;
				s+=(String)dmt.getUserObject();
			}
			File d=new File(s);
			if (d.isDirectory()) {
				for (File dd: d.listFiles()) {
					if (dd.isDirectory()) {
						dmt.add(new DefaultMutableTreeNode(dd.getName()));
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public boolean isPathSelected() {
		waitForWindowClosed();
		return !sPathSelected.isEmpty();
	}

	public String getPathSelected() {
		waitForWindowClosed();
		return sPathSelected;
	}

	private void waitForWindowClosed() {
		try {
			for (;;) {
				boolean b;
				semClose.acquire();	b=isClosed; semClose.release();
				if (b) return;
				Thread.sleep(100);
			}
		} catch (Exception e) {
		}
	}

	public void buildGUI() throws Exception {
	    jf.setSize(400, 600);
	    jf.setLayout(new GridLayout(1,1));
	    jf.getContentPane().add(jsp);
	    jf.setLocationRelativeTo(null);
		jt.setExpandsSelectedPaths(true);
		popup.add((jmiSelect=new JMenuItem("Select current entry and close this dialog")));
		popup.add((jmiClose=new JMenuItem("Close this dialog (no selection)")));
		jmiSelect.addActionListener(this);
		jmiClose.addActionListener(this);
		int ch=File.separatorChar;
		String[] sPathList=rootDir.getAbsolutePath().split(String.format("\\%c", ch));
		DefaultMutableTreeNode dmtLast=dmtRoot;
		for (File dr: File.listRoots()) {
			DefaultMutableTreeNode dmt;
			dmtRoot.add((dmt=new DefaultMutableTreeNode(dr.getAbsolutePath())));
			if (sPathList[0].charAt(0)==dr.getAbsolutePath().charAt(0)) dmtLast=dmt;
		}
		TreePath tp=null;
		for (int i=1;i<sPathList.length;i++) {
			@SuppressWarnings("unchecked")
			Enumeration<DefaultMutableTreeNode> e = dmtLast.children();
			boolean isFound=false;
			DefaultMutableTreeNode dmtc=null;
			while (e.hasMoreElements()) {
				dmtc=e.nextElement();
				if (dmtc.getUserObject().equals(sPathList[i])) {
					isFound=true; break;
				}
			}
			DefaultMutableTreeNode dmt=(isFound)?dmtc:new DefaultMutableTreeNode(sPathList[i]);
			dmtLast.add(dmt); dmtLast=dmt;
			tp=new TreePath(dmt.getPath());
			jt.setSelectionPath(tp);
			showSubDirsOfPath(tp);
		}
		jt.scrollPathToVisible(tp);
		jt.addTreeSelectionListener(this);
		jt.addMouseListener(this);
		jf.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		jf.addWindowListener(this);
		jf.setIconImage(img);
	    jf.setVisible(true);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource()==jmiClose) {
			jf.dispose(); return;
		}
		if (e.getSource()==jmiSelect) {
			sPathSelected=treePathToAbsolutePath(jt.getSelectionPath());
			jf.dispose(); return;
		}
	}

	public void valueChanged(TreeSelectionEvent e) {
		TreePath tp=e.getPath();
		showSubDirsOfPath(tp);
	}

	public void maybeShowPopup(MouseEvent e) {
		if (e.isPopupTrigger() && e.getSource()==jt) {
			popup.show(jt, e.getX(), e.getY());
		}
	}

	public void mousePressed(MouseEvent e) { maybeShowPopup(e); }
	public void mouseReleased(MouseEvent e) { maybeShowPopup(e);}
	public void mouseEntered(MouseEvent e) { }
	public void mouseExited(MouseEvent e) { }
	public void mouseClicked(MouseEvent e) { }

	public void windowOpened(WindowEvent e) { }
	public void windowClosing(WindowEvent e) { }
	public void windowClosed(WindowEvent e) {
		try {
			semClose.acquire();
			isClosed=true;
			semClose.release();
		} catch (Exception ex) {
			return;
		}
	}
	public void windowIconified(WindowEvent e) { }
	public void windowDeiconified(WindowEvent e) { }
	public void windowActivated(WindowEvent e) { }
	public void windowDeactivated(WindowEvent e) { }
}
