package net.nieden.FileCrypter;

import java.io.*;
import java.util.*;
import java.text.*;
import java.security.*;
import javax.crypto.*;

public class CFileHeader {
	final static int HDR_NETTO_SIZE=26, MAGIC_REGULAR=0xab, MAGIC_PASSWD=0xac, MAGIC_COMPRESS=0xad, MAGIC_PASSWD_COMPRESS=0xae;
	int[] bMagicHdr = { 0x9e, 0x7a, MAGIC_REGULAR, 0xff };
	int[] bHdrSize = new int[2]; // { 0, 0 };
	int[] bBlockCountSize = new int[8]; // { 0, 0, 0, 0, 0, 0, 0, 0 };
	int[] bFileSizeAndDate = new int[12]; // { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	byte[] cryptedFilename, md5Passwd=null;
	int blockCount, blockSizeKB, timeStamp;
	long originalFileSize;
	boolean compression, storePasswd;
	String originalFileName;
	Date lastModified;

	public CFileHeader(int blockSizeKB, boolean compression, File inputFile, Cipher cipher) throws Exception {
		this(blockSizeKB, compression, inputFile, cipher, null);
	}

	
	public CFileHeader(int blockSizeKB, boolean compression, File inputFile, Cipher cipher, String passwd) throws Exception {
		/**
		 * constructs a file header for encryption
		 */
		this.compression=compression;
		this.blockSizeKB=blockSizeKB;
		if (passwd!=null) bMagicHdr[2]++;
		if (compression) bMagicHdr[2]+=2;

		originalFileSize=inputFile.length();
		lastModified=new Date(inputFile.lastModified());
		blockCount=(int)(originalFileSize/(1024*blockSizeKB));
		if (originalFileSize%(1024*blockSizeKB)>0) blockCount++;
		CFileTools.longToIntArray((long)blockCount, bBlockCountSize, 0, 2);
		CFileTools.longToIntArray((long)blockSizeKB, bBlockCountSize, 2, 6);

		CFileTools.longToIntArray(inputFile.length(), bFileSizeAndDate, 0, 8);
		CFileTools.longToIntArray(timeStamp=(int)(inputFile.lastModified()/1000), bFileSizeAndDate, 8, 4);
		cryptedFilename=CFileTools.encryptBlock(cipher, inputFile.getName().getBytes());
		CFileTools.longToIntArray((long)(26+cryptedFilename.length), bHdrSize, 0, 2);
		if (passwd!=null) {
			/**
			 * build a md5hash for the password
			 * this will allow the decoder to check the password!
			 */
			md5Passwd=MessageDigest.getInstance("MD5").digest(passwd.getBytes("UTF-8"));
		}
		CFileTools.longToIntArray((long)((passwd==null)?0:16+26+cryptedFilename.length), bHdrSize, 0, 2);
	}

	
	public CFileHeader(InputStream is, Cipher cipher) throws Exception {
		this(is, cipher, null);
	}

	public CFileHeader(InputStream is, Cipher cipher, String passwd) throws Exception {
		/**
		 * constructs a file header from an existing file
		 */
		byte[] fixHdr=new byte[HDR_NETTO_SIZE];
		
		is.read(fixHdr, 0, fixHdr.length);
		if ((fixHdr[0]&0xff)!=0x9e ||(fixHdr[1]&0xff)!=0x7a || (fixHdr[3]&0xff)!=0xff)
			throw new Exception(String.format("Invalid Header-Magic: %02x %02x %02x %02x",
				fixHdr[0]&0xff,fixHdr[1]&0xff,fixHdr[2]&0xff,fixHdr[3]&0xff));
		if ((fixHdr[2]&0xff)==0xab) {
			compression=false;
			storePasswd=false;
		} else if ((fixHdr[2]&0xff)==0xac) {
			compression=false;
			storePasswd=true;
		} else if ((fixHdr[2]&0xff)==0xad) {
			compression=true;
			storePasswd=false;
		} else if ((fixHdr[2]&0xff)==0xae) {
			compression=true;
			storePasswd=true;
		} else throw new Exception("Invalid Header-Compression state!");
		int hdrSize=CFileTools.byteArrayToInt(fixHdr, 4, 2);
		blockCount=CFileTools.byteArrayToInt(fixHdr, 6, 2);
		blockSizeKB=CFileTools.byteArrayToInt(fixHdr, 8, 6);
		originalFileSize=CFileTools.byteArrayToLong(fixHdr, 14, 8);
		timeStamp=CFileTools.byteArrayToInt(fixHdr, 22, 4);
		lastModified=new Date(1000*(long)timeStamp);
		int fileNameLength=hdrSize-HDR_NETTO_SIZE;
		if (storePasswd) fileNameLength-=16;
		cryptedFilename=new byte[fileNameLength];
		is.read(cryptedFilename, 0, fileNameLength);
		if (storePasswd) {
			md5Passwd=new byte[16];
			is.read(md5Passwd, 0, md5Passwd.length);
			if (passwd!=null) {
				/**
				 * if a passwd is given
				 * check the password right here ...
				 */
				byte[] md5Passwd_Given=MessageDigest.getInstance("MD5").digest(passwd.getBytes("UTF-8"));
				if (!CFileTools.byteArrayCompare(md5Passwd_Given,md5Passwd)) {
					String s="";
					for (int i=0;i<16;i++) {
						s+=String.format("%02x ", md5Passwd_Given[i]&0xff);
					}
					s+="\n";
					for (int i=0;i<16;i++) {
						s+=String.format("%02x ", md5Passwd[i]&0xff);
					}
					System.err.println(s);
					throw new Exception("Password given does not match password with which this file has been encrypted!");
				}
			}
		}
		originalFileName=new String(CFileTools.decryptBlock(cipher, cryptedFilename));
	}

	public String toString() {
		return String.format("[%c] %s%14s %s",
			compression?'+':'-',
			new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(lastModified),
			CFileTools.printDottedNumber(originalFileSize),
			originalFileName);
	}

	public void writeHdr(OutputStream os) throws Exception {
		byte[] fixHdr=new byte[HDR_NETTO_SIZE];
		CFileTools.intArrayToByteArray(bMagicHdr, fixHdr, 0);
		CFileTools.intArrayToByteArray(bHdrSize, fixHdr, 4);
		CFileTools.intArrayToByteArray(bBlockCountSize, fixHdr, 6);
		CFileTools.intArrayToByteArray(bFileSizeAndDate, fixHdr, 14);
		os.write(fixHdr, 0, fixHdr.length);
		os.write(cryptedFilename, 0, cryptedFilename.length);
		if (md5Passwd!=null)
			os.write(md5Passwd, 0, md5Passwd.length);
		os.flush();
	}
}
