#include "ellipse_p.h"

#include <QPainter>

Ellipse::Ellipse()
    : Shape( new Private( QPointF(), 0, 0, this ) )
{
    d_func()->init();
}

Ellipse::Ellipse( const QPointF & center, double a, double b )
    : Shape( new Private( center, a, b, this ) )
{
    d_func()->init();
}

Ellipse::~Ellipse() {}

void Ellipse::Private::doDraw( QPainter * p ) const {
    p->drawEllipse( center, a, b );
}

Ellipse * Ellipse::clone() const {
    const Private * const d = d_func();
    return new Ellipse( d->center, d->a, d->b );
}

QPointF Ellipse::center() const {
    return d_func()->center;
}

void Ellipse::setCenter( const QPointF & center ) {
    d_func()->center = center;
}

double Ellipse::radiusA() const {
    return d_func()->a;
}

double Ellipse::radiusB() const {
    return d_func()->b;
}

void Ellipse::setRadii( double a, double b ) {
    Private * const d = d_func();
    d->a = a;
    d->b = b;
}
