#include <QtGui>

#include "rectangle.h"
#include "ellipse.h"

#include <boost/shared_ptr.hpp>

class ShapeWidget : public QWidget {
    Q_OBJECT
public:
    explicit ShapeWidget( QWidget * parent=0 )
        : QWidget( parent ),
          m_shapes()
    {

    }

    void addShape( const boost::shared_ptr<Shape> & shape ) {
        m_shapes.push_back( shape );
        update();
    }

protected:
    void paintEvent( QPaintEvent * ) {
        QPainter p( this );
        p.setWindow( 0, 0, 1, 1 );
        p.setRenderHint( QPainter::Antialiasing );
        Q_FOREACH( const boost::shared_ptr<Shape> & shape, m_shapes )
            if ( shape )
                shape->draw( &p );
    }

private:
    std::vector< boost::shared_ptr<Shape> > m_shapes;
};

int main( int argc, char * argv[] ) {

    QApplication app( argc, argv );

    ShapeWidget w;

    const boost::shared_ptr<Shape> r( new Rectangle( QRectF( 0.00, 0.00, 0.50, 0.50 ) ) );
    r->setPen( QColor( Qt::red ) );
    r->setBrush( QColor( 0xff, 0x00, 0x00, 0x80 ) );
    const boost::shared_ptr<Shape> e( new Ellipse( QPointF( 0.50, 0.50 ), 0.25, 0.25 ) );
    e->setPen( QColor( Qt::blue ) );
    e->setBrush( QColor( 0x00, 0x00, 0xff, 0x80 ) );

    w.addShape( r );
    w.addShape( e );
    w.show();

    return app.exec();
}

#include "main.moc"
