#ifndef PIMPL_ELLIPSE_H__
#define PIMPL_ELLIPSE_H__

#include "shape.h"

class QPointF;

class Ellipse : public Shape {
public:
    Ellipse();
    explicit Ellipse( const QPointF & center, double a, double b );
    ~Ellipse();

    /* reimp */ Ellipse * clone() const;

    QPointF center() const;
    void setCenter( const QPointF & center );

    double radiusA() const;
    double radiusB() const;
    void setRadii( double a, double b );

protected:
    // defined in ellipse_p.h:
    class Private;
    inline Private * d_func();
    inline const Private * d_func() const;
    inline explicit Ellipse( Private * );
};

#endif /* PIMPL_ELLIPSE_H__ */
