#include "shape_p.h"

#include <QPainter>
#include <QString>

Shape::Shape()
    : _d( new Private( this ) )
{
    d_func()->init();
}

Shape::~Shape() {
    // set _d and _q to 0 to provoke null-pointer dereferences on
    // unwanted use during destruction:
    Private * const d = _d;
    d->_q = 0;
    _d = 0;
    delete d;
}

void Shape::draw( QPainter * p ) const {
    if ( !p )
        return;
    const Private * const d = d_func();
    p->save();
    p->setPen( d->pen );
    p->setBrush( d->brush );

    d->doDraw( p );

    p->restore();
}

void Shape::Private::doDraw( QPainter * p ) const {
    p->drawText( 0, 0, QLatin1String( "Shape::doDraw" ) );
}

void Shape::setPen( const QPen & pen ) {
    d_func()->pen = pen;
}

const QPen & Shape::pen() const {
    return d_func()->pen;
}

void Shape::setBrush( const QBrush & brush ) {
    d_func()->brush = brush;
}

const QBrush & Shape::brush() const {
    return d_func()->brush;
}
