package loginexample
{
	import loginexample.controller.LoginCommand;
	import loginexample.controller.StartupCommand;
	
	import org.puremvc.as3.interfaces.IFacade;
	import org.puremvc.as3.patterns.facade.Facade;

	public class ApplicationFacade extends Facade implements IFacade
	{
		
		/*
		 * NOTIFICATION IDs 
		 */		
		public static const STARTUP:String 	= "startup";
		public static const LOGIN:String 	= "login";
		
		
		/*
		* Singleton implementierung 
		*/
		public static function getInstance():ApplicationFacade
		{
			if( instance == null )
				instance = new ApplicationFacade();
			return instance as ApplicationFacade;
		} 

		
		/*
		 * Notification IDs mit Commands verknüpfen (Mapping)
		 */		
		override protected function initializeController():void
		{
			super.initializeController();
			
			registerCommand( STARTUP, StartupCommand );
			registerCommand( LOGIN, LoginCommand );
			
		}
		
	}
}