package loginexample.controller
{
	import loginexample.model.ConfigProxy;
	import loginexample.model.UserProxy;
	
	import org.puremvc.as3.interfaces.ICommand;
	import org.puremvc.as3.interfaces.INotification;
	import org.puremvc.as3.patterns.command.SimpleCommand;

	public class LoginCommand extends SimpleCommand implements ICommand
	{

		override public function execute( notification:INotification ):void
		{
			// auslesen des Notification Bodys
			var logindata:Array = notification.getBody() as Array;
			var username:String = logindata[ 0 ] as String;
			var password:String = logindata[ 1 ] as String;
			
			// Login Service aus ConfigProxy holen
			var configproxy:ConfigProxy = facade.retrieveProxy( ConfigProxy.NAME ) as ConfigProxy;
			var loginservice:String = configproxy.ConfigData.LoginService;
			
			// Login ausführen
			var userproxy:UserProxy = facade.retrieveProxy( UserProxy.NAME ) as UserProxy;
			userproxy.login( loginservice, username, password );
		}
		
	}
}