package loginexample.model
{
	import loginexample.model.vo.UserVO;
	
	import org.puremvc.as3.interfaces.IProxy;
	import org.puremvc.as3.patterns.proxy.Proxy;

	public class UserProxy extends Proxy implements IProxy
	{
		
		public static const NAME:String = "userProxy";
		
		/*
		 * NOTIFICATION IDs 
		 */		
		public static const LOGIN_SUCCESS:String 		= NAME + ".loginSucess";
		public static const LOGIN_FAULT:String 			= NAME + ".loginFault";
		 
		
		public function UserProxy()
		{
			super( NAME );
		}
		
		/* 
		 * Login 
		 */
		public function login( loginservice:String, username:String, password:String ):void
		{
			// Fake Remote Call
			//trace( "Loginservice", loginservice )
			if( password == "pass" )
				onResult( [ "Thomas", "Reppa" ] );
			else 
				onFault( null );
		} 
		
		
		public function onResult( data:Object ):void
		{
			// UserVO instanziieren
			var vo:UserVO = new UserVO( data );
			
			// VO im Proxy cachen
			setData( vo );
			
			// Notification senden
			sendNotification( LOGIN_SUCCESS, vo );
		}
		

		public function onFault( data:Object ):void
		{
			sendNotification( LOGIN_FAULT );
		} 
		
		
	}
}