package loginexample.view
{
	import loginexample.model.ConfigProxy;
	import loginexample.model.UserProxy;
	
	import org.puremvc.as3.interfaces.IMediator;
	import org.puremvc.as3.interfaces.INotification;
	import org.puremvc.as3.patterns.mediator.Mediator;

	public class ApplicationMediator extends Mediator implements IMediator
	{
		
		/*
		* MEDIATOR ID
		*/
		public static const NAME:String = "applicationMediator";
		
		
		public function ApplicationMediator( viewComponent:PMVC_Login )
		{
			super( NAME, viewComponent);
			
			// Register Mediators
			facade.registerMediator( new LoginViewMediator( appView.loginView ) );
			facade.registerMediator( new MainMediator( appView.mainView ) );
		}
		
		/*
		 * Wird bei der Registrierung des Mediators einmalig aufgerufen
		 */
		override public function listNotificationInterests():Array
		{
			return 	[
					UserProxy.LOGIN_SUCCESS,
					ConfigProxy.CONFIG_LOADED
					];
		}
		
		
		override public function handleNotification(notification:INotification):void
		{
			switch( notification.getName() )
			{	
				case UserProxy.LOGIN_SUCCESS:
					changeAppView( PMVC_Login.MAIN_VIEW );
					break;
					
				case ConfigProxy.CONFIG_LOADED:
					changeAppView( PMVC_Login.LOGIN_VIEW );
					break;
				
				default:
					break;
			}
		}
		
		public function changeAppView( viewindex:uint ):void
		{
			appView.changeAppView( viewindex );
		}
		
		
		private function get appView():PMVC_Login
		{
			return viewComponent as PMVC_Login;
		}
		
		
	}
}