package loginexample.view
{
	import loginexample.ApplicationFacade;
	import loginexample.model.UserProxy;
	import loginexample.view.components.LoginView;
	import loginexample.view.components.UIEvent;
	
	import org.puremvc.as3.interfaces.IMediator;
	import org.puremvc.as3.interfaces.INotification;
	import org.puremvc.as3.patterns.mediator.Mediator;

	public class LoginViewMediator extends Mediator implements IMediator
	{
		
		public static const NAME:String = "loginViewMediator";
		
		public function LoginViewMediator( viewComponent:LoginView )
		{
			super( NAME, viewComponent );
			
			loginView.addEventListener( LoginView.EVENT_LOGIN, onLogin );
		}
		
		private function onLogin( event:UIEvent ):void
		{
			sendNotification( ApplicationFacade.LOGIN, event.Payload );
		}
		
		/*
		 * Wird bei der Registrierung des Mediators einmalig aufgerufen
		 */
		override public function listNotificationInterests():Array
		{
			return 	[
					UserProxy.LOGIN_FAULT
					];
		}
		
		/*
		 * Ausführen des entspechenden Codes anhand der Notification ID
		 */
		override public function handleNotification( notification:INotification ):void
		{
			switch( notification.getName() )
			{
				case UserProxy.LOGIN_FAULT:
					loginView.shakeIt();
					break;
			}
		}
		
		
		private function get loginView():LoginView
		{
			return viewComponent as LoginView;
		}

		
	}
}