package loginexample.view
{
	import loginexample.model.UserProxy;
	import loginexample.model.vo.UserVO;
	import loginexample.view.components.MainView;
	
	import org.puremvc.as3.interfaces.IMediator;
	import org.puremvc.as3.interfaces.INotification;
	import org.puremvc.as3.patterns.mediator.Mediator;

	public class MainMediator extends Mediator implements IMediator
	{
		
		public static const NAME:String = "mainMediator";
		
		public function MainMediator( viewComponent:MainView )
		{
			super( NAME, viewComponent);
		}

		/*
		* Wird bei der Registrierung des Mediators einmalig aufgerufen
		*/
		override public function listNotificationInterests():Array
		{
			return 	[
					UserProxy.LOGIN_SUCCESS
					];
		}
		
		/*
		 * Ausführen des entspechenden Codes anhand der Notification ID
		 */
		override public function handleNotification(notification:INotification):void
		{
			switch( notification.getName() )
			{
				case UserProxy.LOGIN_SUCCESS:
					mainView.setUserData( notification.getBody() as UserVO );
					break;
			}

		}
		
		
		private function get mainView():MainView
		{
			return viewComponent as MainView;
		}

		
	}
}