﻿using System;
using System.Collections.Generic;
using WWWings_GL;
using WWWings_GO;

namespace WWWings_TestKonsole
{
 class Program
 {
  static void Main(string[] args)
  {
   Console.Title = "World aus Wide Wings - Tutorial - Testkonsole";
   Console.WriteLine("Start...");

   // Nur einmalig ausführen, um DB zu befüllen!
   // WWWings_GL.Datengenerator.Init_DB();

   FlugBuchenDemo();

   Console.WriteLine("Fertig!");
   Console.ReadLine();
  }


  private static void FlugBuchenDemo()
  {

   BuchungsManager bm = new BuchungsManager();

   // ----------- Flug ermitteln
   int FlugID = 101;
   int PassagierID = 401;
   Flug f = bm.GetFlug(FlugID);


   if (f == null)
   {
    Console.WriteLine("Flug nicht gefunden!");
   }
   else
   {
    Console.WriteLine("Flug: " + f.ToString());
   }

   // ----------- Neuen Passagier anlegen
   Passagier pneu = new Passagier();
   pneu.Vorname = "Max";
   pneu.Name = "Mustermann";
   pneu.PassagierStatus = "C";
   pneu.Geburtsdatum = DateTime.Now.AddYears(-40);

   List<Passagier> GeändertePassagiere = new List<Passagier>() { pneu };
   string Statistik;
   var antwort = bm.SavePassagierSet(GeändertePassagiere, out Statistik);

   Console.WriteLine("Statistik von SavePassagierSet: " + Statistik);

   // Der erste neue Passagier muss der angelegte sein, der nun auch die ID enthält!
   pneu = antwort[0];

   if (pneu == null)
   {
    Console.WriteLine("Passagier nicht gefunden!");
   }
   else
   {
    Console.WriteLine("Passagier: " + pneu.ToString());
   }

   // ----------- Buchung erzeugen
   var Ergebnis = bm.CreateBuchung(FlugID, pneu.ID);
   Console.WriteLine("Ergebnis der Buchung: " + Ergebnis);

   // ----------- Flugdaten aktualisieren
   Flug fnachher = bm.GetFlug(FlugID);
   if (fnachher == null)
   {
    Console.WriteLine("Flug nicht gefunden!");
   }
   else
   {
    Console.WriteLine("Flug: " + fnachher.ToString());
   }
   bm.Dispose(); // WICHTIG!!!

  } // Ende FlugBuchenDemo()
 } // Ende Class
} // Ende Namespace
