VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ACLfunc"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' EXACL is a COM-Object to set the ACL of an Exchange Mailbox.
' Programmed by Holger Schwichtenberg, hs@it-visions.de -- 1998
' Based on Microsoft example code by Richard Ault, Jean-Philippe Balivet, Neil Wemple -- 1998
' Version 2.0

Option Explicit

' Mailbox property settings
 Const LOGON_CMD = "logon.cmd"
 Const INCOMING_MESSAGE_LIMIT = 1000
 Const OUTGOING_MESSAGE_LIMIT = 1000
 Const WARNING_STORAGE_LIMIT = 8000
 Const SEND_STORAGE_LIMIT = 12000
 Const REPLICATION_SENSITIVITY = 20
 Const COUNTRY = "US"

' Mailbox rights for Exchange security descriptor (home made)
 Const RIGHT_MODIFY_USER_ATTRIBUTES = &H2
 Const RIGHT_MODIFY_ADMIN_ATTRIBUTES = &H4
 Const RIGHT_SEND_AS = &H8
 Const RIGHT_MAILBOX_OWNER = &H10
 Const RIGHT_MODIFY_PERMISSIONS = &H80
 Const RIGHT_SEARCH = &H100

' win32 constants for security descriptors (from VB5 API viewer)
 Const ACL_REVISION = (2)
 Const SECURITY_DESCRIPTOR_REVISION = (1)
 Const SidTypeUser = 1

Type ACL
        AclRevision As Byte
        Sbz1 As Byte
        AclSize As Integer
        AceCount As Integer
        Sbz2 As Integer
End Type

Type ACE_HEADER
        AceType As Byte
        AceFlags As Byte
        AceSize As Long
End Type

Type ACCESS_ALLOWED_ACE
        Header As ACE_HEADER
        Mask As Long
        SidStart As Long
End Type

Type SECURITY_DESCRIPTOR
        Revision As Byte
        Sbz1 As Byte
        Control As Long
        Owner As Long
        Group As Long
        Sacl As ACL
        Dacl As ACL
End Type

' Just an help to allocate the 2dim dynamic array
Private Type mySID
    x() As Byte
End Type


' Declares : modified from VB5 API viewer
Private Declare Function InitializeSecurityDescriptor Lib "advapi32.dll" _
        (pSecurityDescriptor As SECURITY_DESCRIPTOR, _
        ByVal dwRevision As Long) As Long

Private Declare Function SetSecurityDescriptorOwner Lib "advapi32.dll" _
        (pSecurityDescriptor As SECURITY_DESCRIPTOR, _
        pOwner As Byte, _
        ByVal bOwnerDefaulted As Long) As Long

Private Declare Function SetSecurityDescriptorGroup Lib "advapi32.dll" _
        (pSecurityDescriptor As SECURITY_DESCRIPTOR, _
        pGroup As Byte, _
        ByVal bGroupDefaulted As Long) As Long

Private Declare Function SetSecurityDescriptorDacl Lib "advapi32.dll" _
        (pSecurityDescriptor As SECURITY_DESCRIPTOR, _
        ByVal bDaclPresent As Long, _
        pDacl As Byte, _
        ByVal bDaclDefaulted As Long) As Long

Private Declare Function SetSecurityDescriptorSacl Lib "advapi32.dll" _
        (pSecurityDescriptor As SECURITY_DESCRIPTOR, _
        ByVal bSaclPresent As Long, _
        pSacl As Byte, _
        ByVal bSaclDefaulted As Long) As Long

Private Declare Function MakeSelfRelativeSD Lib "advapi32.dll" _
        (pAbsoluteSecurityDescriptor As SECURITY_DESCRIPTOR, _
        pSelfRelativeSecurityDescriptor As Byte, _
        ByRef lpdwBufferLength As Long) As Long

Private Declare Function GetSecurityDescriptorLength Lib "advapi32.dll" _
        (pSecurityDescriptor As SECURITY_DESCRIPTOR) As Long

Private Declare Function IsValidSecurityDescriptor Lib "advapi32.dll" _
        (pSecurityDescriptor As Byte) As Long

Private Declare Function InitializeAcl Lib "advapi32.dll" _
        (pACL As Byte, _
        ByVal nAclLength As Long, _
        ByVal dwAclRevision As Long) As Long

Private Declare Function AddAccessAllowedAce Lib "advapi32.dll" _
        (pACL As Byte, _
        ByVal dwAceRevision As Long, _
        ByVal AccessMask As Long, _
        pSid As Byte) As Long

Private Declare Function IsValidAcl Lib "advapi32.dll" _
        (pACL As Byte) As Long

Private Declare Function GetLastError Lib "kernel32" _
        () As Long

Private Declare Function LookupAccountName Lib "advapi32.dll" _
        Alias "LookupAccountNameA" _
        (ByVal IpSystemName As String, _
         ByVal IpAccountName As String, _
         pSid As Byte, _
         cbSid As Long, _
         ByVal ReferencedDomainName As String, _
         cbReferencedDomainName As Long, _
         peUse As Integer) As Long

Private Declare Function NetGetDCName Lib "NETAPI32.DLL" _
        (ServerName As Byte, _
         DomainName As Byte, _
         DCNPtr As Long) As Long
                                         
Private Declare Function NetApiBufferFree Lib "NETAPI32.DLL" _
        (ByVal Ptr As Long) As Long
        
Private Declare Function PtrToStr Lib "kernel32" _
        Alias "lstrcpyW" (RetVal As Byte, ByVal Ptr As Long) As Long

Private Declare Function GetLengthSid Lib "advapi32.dll" _
        (pSid As Byte) As Long

Public Sub about()

MsgBox "EXACL is a COM-Object to set the ACL of an Exchange Mailbox." & Chr(13) & Chr(13) & _
"Programmed by Holger Schwichtenberg, hs@it-visions.de -- 1998." & Chr(13) & Chr(13) & _
"Based on Microsoft example code by Richard Ault, Jean-Philippe Balivet, Neil Wemple -- 1998", vbOKOnly, "About EXACL.dll Version 2.0"

End Sub

' ##################### Setzen des Mailbox-Owners
Public Sub SetOwner(Mailbox As Variant, strDomain As String, username As String)
Dim I As Integer
Dim sSelfSD() As Byte
Dim encodedSD() As Byte
Dim strserver As String
Dim iadsmailbox As IADs

Set iadsmailbox = Mailbox

' PDC der Domain
strserver = Replace(Get_Primary_DCName("", strDomain), "\\", "")

' ACL bilden
Call MakeSelfSD(sSelfSD, _
                            strserver, _
                            strDomain, _
                            username, _
                            username, _
                            RIGHT_MAILBOX_OWNER + RIGHT_SEND_AS + _
                            RIGHT_MODIFY_USER_ATTRIBUTES _
                           )
                           
' Encoding...
ReDim encodedSD(2 * UBound(sSelfSD) + 1)
For I = 0 To UBound(sSelfSD) - 1
    encodedSD(2 * I) = AscB(Hex$(sSelfSD(I) \ &H10))
    encodedSD(2 * I + 1) = AscB(Hex$(sSelfSD(I) Mod &H10))
Next I
    
' Set NT-Sec-Desc
iadsmailbox.Put "NT-Security-Descriptor", encodedSD

End Sub

' ###################### Setzen des Associated-NT-Account
Sub SetAssoc(Mailbox As Variant, strDomain As String, username As String)
Dim rbSID(1024) As Byte
Dim iadsmailbox As IADs
Set iadsmailbox = Mailbox

' GetSid
Get_Exchange_Sid strDomain, username, rbSID

' Schreibe in Assoc-NT-Account
iadsmailbox.Put "Assoc-NT-Account", rbSID

End Sub


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''
'' MakeSelfSD -- builds a self-relative Security Descriptor suitable for ADSI
''
'' Return code : 1 = OK
''               0 = error
'' In    sSelfSD     dynamic byte array, size 0
''       sServer     DC for the domain
''       sDomain     Domain name
''       sAssocUser  Primary NT account for the mail box (SD owner)
''       paramarray  Authorized accounts
''                   This is an array of (userid, role, userid, role...)
''                   where role is a combination of rights (cf RIGHTxxx constants)
'' Out   sSelfSD     Self relative SD allocated and initalized
''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Function MakeSelfSD(sSelfSD() As Byte, _
        sServer As String, sDomain As String, _
        sAssocUSer As String, _
        ParamArray ACEList() As Variant) As Long
Dim SecDesc As SECURITY_DESCRIPTOR
Dim I As Integer
Dim tACL As ACL
Dim tACCESS_ALLOWED_ACE As ACCESS_ALLOWED_ACE
Dim pSid() As Byte
Dim pACL() As Byte
Dim pACESID() As mySID
Dim Longueur As Long
Dim rc As Long
    
    On Error GoTo SDError
    ' Initializing abolute SD
    rc = InitializeSecurityDescriptor(SecDesc, SECURITY_DESCRIPTOR_REVISION)
    If (rc <> 1) Then
        Err.Raise -12, , "InitializeSecurityDescriptor"
    End If
    
    rc = GetSID(sServer, sDomain, sAssocUSer, pSid)
    If (rc <> 1) Then
        Err.Raise -12, , "GetSID"
    End If
    
    rc = SetSecurityDescriptorOwner(SecDesc, pSid(0), 0)
    If (rc <> 1) Then
        Err.Raise -12, , "SetSecurityDescriptorOwner"
    End If
    
    ' I don't know why we had to do this one, but it works for us
    rc = SetSecurityDescriptorGroup(SecDesc, pSid(0), 0)
    If (rc <> 1) Then
        Err.Raise -12, , "SetSecurityDescriptorGroup"
    End If
    
    ' Getting SIDs for all the other users, and computing of total ACL length
    ' (famous formula from MSDN)
    Longueur = Len(tACL)
    ReDim Preserve pACESID((UBound(ACEList) - 1) / 2)
    For I = 0 To UBound(pACESID)
        If 1 <> GetSID(sServer, sDomain, CStr(ACEList(2 * I)), pACESID(I).x) Then Err.Raise -12, , "GetSID"
        Longueur = Longueur + GetLengthSid(pACESID(I).x(0)) + Len(tACCESS_ALLOWED_ACE) - 4
    Next I
    
    ' Initalizing ACL, and adding one ACE for each user
    ReDim pACL(Longueur)
    If 1 <> InitializeAcl(pACL(0), Longueur, ACL_REVISION) Then Err.Raise -12, , "InitializeAcl"
    For I = 0 To UBound(pACESID)
        If 1 <> AddAccessAllowedAce(pACL(0), ACL_REVISION, CLng(ACEList(2 * I + 1)), pACESID(I).x(0)) Then Err.Raise -12, , "AddAccessAllowedAce"
    Next I
    If 1 <> SetSecurityDescriptorDacl(SecDesc, 1, pACL(0), 0) Then Err.Raise -12, , "SetSecurityDescriptorDacl"
    
    ' Allocation and conversion in the self relative SD
    Longueur = GetSecurityDescriptorLength(SecDesc)
    ReDim sSelfSD(Longueur)
    If 1 <> MakeSelfRelativeSD(SecDesc, sSelfSD(0), Longueur) Then Err.Raise -12, , "MakeSelfRelativeSD"
    MakeSelfSD = 1
    Exit Function

SDError:
    MakeSelfSD = 0
End Function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''
'' GetSID -- gets the Security IDentifier for the specified account name
''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Function GetSID(sServer As String, sDomain As String, sUserID As String, pSid() As Byte) As Long
Dim rc As Long
Dim pDomain() As Byte
Dim lSID As Long, lDomain As Long
Dim sSystem As String, sAccount As String

    On Error GoTo SIDError
    
    ReDim pSid(0)
    ReDim pDomain(0)
    lSID = 0
    lDomain = 0
    sSystem = "\\" & sServer
    sAccount = sDomain & "\" & sUserID
    
    rc = LookupAccountName(sSystem, sAccount, pSid(0), lSID, pDomain(0), lDomain, SidTypeUser)
    
    If (rc = 0) Then
        ReDim pSid(lSID)
        ReDim pDomain(lDomain + 1)

        rc = LookupAccountName(sSystem, sAccount, pSid(0), lSID, pDomain(0), lDomain, SidTypeUser)
        If (rc = 0) Then
            GoTo SIDError
        End If
    End If
    
    GetSID = 1
    Exit Function

SIDError:
    GetSID = 0
End Function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''
'' Get_Primary_DCName -- gets the name of the Primary Domain Controller for
''                       the NT domain
''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Function Get_Primary_DCName(ByVal MName As String, ByVal DName As String) As String

Dim Result As Long
Dim DCName As String
Dim DCNPtr As Long
Dim DNArray() As Byte
Dim MNArray() As Byte
Dim DCNArray(100) As Byte

    MNArray = MName & vbNullChar
    DNArray = DName & vbNullChar
    Result = NetGetDCName(MNArray(0), DNArray(0), DCNPtr)
    If Result <> 0 Then
        Exit Function
    End If
    Result = PtrToStr(DCNArray(0), DCNPtr)
    Result = NetApiBufferFree(DCNPtr)
    DCName = DCNArray()
    Get_Primary_DCName = DCName
    
End Function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''
'' Get_Exchange_Sid -- gets the NT user's Security IDentifier for Exchange
''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub Get_Exchange_Sid(strNTDomain As String, strNTAccount As String, rbSID() As Byte)

Dim pSid(512) As Byte
Dim pDomain(512) As Byte
Dim IReturn As Long
Dim I As Integer

    IReturn = LookupAccountName(Get_Primary_DCName("", strNTDomain), strNTAccount, pSid(0), 512, pDomain, 512, 1)
    
    For I = 0 To GetLengthSid(pSid(0)) - 1
        rbSID(2 * I) = AscB(Hex$(pSid(I) \ &H10))
        rbSID(2 * I + 1) = AscB(Hex$(pSid(I) Mod &H10))
    Next I
End Sub
