
' MAILBOX-BATCH fr Exchange Server 5.5
' Autor: Holger Schwichtenberg, hs@it-visions.de, http://www.it-visions.de
' Stand: 5-1-99
' bentigte Komponenten:
' - ADSI >= 2.0 (siehe Alternative fr ADSI 2.5)
' - Scripting Runtime
' - EXACL.dll
' - Datei newmails.txt

' ########################################### Enviroment

' *** Enviroment NT-Domain

strNTDomain = "NTDom"

' *** Enviroment Exchange-Server

strServerName = "ExServ"
strOU = "Site"
strO = "Firma"
strMTA = "cn=Microsoft MTA,cn=" + StrServerName + ",cn=Servers,cn=Configuration,ou=" + StrOU + ",o=" + strO
strMDB = "cn=Microsoft Private MDB,cn=" + StrServerName + ",cn=Servers,cn=Configuration,ou=" + StrOU + ",o=" + strO
strExadmin_user = "cn=user, cn=domain"
strExadmin_pwd = "pwd"
strContainerRDN = "test"
strContainer = "LDAP://" + StrServerName + "/cn="&strContainerRDN&", cn=Recipients,ou=" + StrOU + ",o=" + strO

' *** Enviroment Sonstiges
config_file = "c:\newmails.txt"

' ########################################### Funktionen zum Auslesen des CSV-Files

Dim strFSO	' FileSystem-Objekt
Dim objTS	' Textstream-Objekt
Dim strLine	' Eine Zeile

' --- ffnen eines Textfiles
Sub csv_open(filename)
Set objFSO = CreateObject("Scripting.filesystemobject")
Set objTS = objFSO.OpenTextFile(filename)
End Sub

' --- Zeile auslesen
Function csv_readline()
If objTS.AtEndOfStream Then
    csv_readline = False
Else
    strLine = objTS.readline
    csv_readline = True
End If
End Function

' --- Feld (bis zum ;) einlesen
Function csv_getfield()
pos = InStr(strLine, ";")
If pos = 0 Then	' letztes Feld
    csv_getfield = strLine
    strLine = ""
Else			' noch nicht letztes Feld
    csv_getfield = Left(strLine, pos - 1)
    strLine = Right(strLine, Len(strLine) - pos)
End If
End Function

' ########################################### Sonstige Funktionen

' Meldung ausgeben

Dim intMeldCount	' Zhler fr Meldungen
Dim strMeldungsRecord	' Liste aller Meldungen

Sub Meldung(s)
intMeldCount = intMeldCount +1
strMeldungsText = "Protokoll " & intMeldCount & ": " & s 
strMeldungsRecord = strMeldungsRecord & strMeldungsText & chr(13)
wscript.echo strMeldungsText
end sub

' ########################################### Hauptprogramm

Dim objNS		' Namespace ADSI-Objekt
Dim objContainer	' Exchange-Container ADSI-Objekt
Dim objMailbox	' Exchange-Mailbox ADSI-Objekt
Dim objEXACL		' COM-Objekt


Meldung "Starting Batch..."

' --- ffnen des Konfig-Files
csv_open (config_file)

' --- Iteration ber alle Zielen in Konfig-File
Do While csv_readline

' --- Auslesen der Felder
strFirstname = csv_getfield
strLastname = csv_getfield
strAlias = csv_getfield
strEMail = csv_getfield
strTel = csv_getfield
strNTUser = csv_getfield

' Vereinbarung: Display und DirName = Alias
strDisplayName = strAlias
strDirectoryName = strAlias


' --- Exchange-Mailbox erzeugen

' Container ffnen
Set objNS = GetObject("LDAP:")
Set objContainer = objNS.OpenDSObject(strContainer, strExadmin_user, strExadmin_pwd, 0)
' Mailbox erzeugen
Set objMailbox = objContainer.Create("organizationalPerson", "cn=" + cstr(strDirectoryName))

' Individuelle Attribute setzen
objMailbox.Put "givenName", CStr(strFirstname)
objMailbox.Put "sn", CStr(strLastName)
objMailbox.Put "cn", CStr(strDisplayName)
objMailbox.Put "uid", CStr(strAlias)
objMailbox.Put "mail", CStr(strEMail)
objMailbox.Put "TelephoneNumber", Cstr(strTel)
objMailbox.Put "rfc822Mailbox", CStr(strEMail)
objMailbox.Put "textEncodedORaddress", CStr("c=US;a= ;p=" + strO + ";o=" + StrOU + ";s=" + strAlias + ";")

' Sonstige Notwendige Attribute
objMailbox.Put "Home-MTA", CStr(strMTA)
objMailbox.Put "Home-MDB", CStr(strMDB)
objMailbox.Put "mailPreferenceOption", 0
objMailbox.Put "MDB-Use-Defaults", True
objMailbox.Put "Replication-Sensitivity", 20

' --- ACL und Assoc-NT-Account setzen
' COM Objekt ffnen
Set objEXACL = CreateObject("EXACL.ACLfunc")

' a) ACL Ermitteln und speichern
objEXACL.SetOwner objMailbox, cstr(strNTDomain), cstr(strNTUser)

' b) SID des Assoc-NT-Account Ermitteln und speichern
objEXACL.SetAssoc objMailbox, cstr(strNTDomain), cstr(strNTUser)	' fr ADSI 2.0 !!!

' *********************** Alternative zu b) fr ADSI 2.0 mit ADSI-eigenen Mitteln!
' Set u = GetObject("WinNT://" & strNTDomain & "/" & strNTUser)
' sid = u.Get("ObjectSID")
' strsid = ""
' --- Umwandeln der SID
' For i = (LBound(sid) + 1) To (UBound(sid) + 1)
' strsid = strsid & Hex(AscB(MidB(sid, i, 1)) \ 16) & Hex(AscB(MidB(sid, i,1)) Mod 16)
' Next
' --- In Mailbox-Objekt speichern
' objMailbox.Put "Assoc-NT-Account", CStr(strsid)
' ***********************

' --- Cache in Verzeichnis schreiben
objMailbox.SetInfo

' --- Aufrumen
set objNS = Nothing
set objContainer = Nothing
set objMailbox = Nothing
set objEXACL = Nothing

Meldung "Postfach " & strAlias & " erfolgreich angelegt fr "&strNTDomain & "\" & strNTUser & " !"

' Schleife beenden
Loop