#!/usr/bin/env python

# file: AccountClient.py

# Standard/built-in modules
import sys

# Fnorb modules
from Fnorb.orb import CORBA

# Stubs generated by 'fnidl'
import AccountModule


def main(argv):
    # Initialise the ORB.
    print 'Initialising the ORB...'
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # Read the server's stringified IOR from a file
    f = open('server.ref', 'r')
    stringified_ior = f.read()
    f.close()

    # Convert the stringified IOR into an active object reference
    object = orb.string_to_object(stringified_ior)

    # Make sure the server is what we expect
    print object._is_a('IDL:AccountModule/Account:1.0')

    # Call the server
    print 'balance of', object, 'is', object._get_balance()
    object.makeLodgement(130.0)
    print object._get_balance()

#    try:
    object.makeWithdrawal(12.0)

#    except Account.reject, ex:
#	print 'Got user exception:', ex.reason
#

    try:
    	object._get_balance()


    except CORBA.SystemException, ex:
	print 'Got system exception:', ex
  
    return 0


#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
