#!/usr/bin/env python

# file: AccountServer.py

# Standard/built-in modules
import sys

# Fnorb modules
from Fnorb.orb import BOA, CORBA

# Stubs and skeletons generated by 'fnidl'
import AccountModule, AccountModule_skel


class AccountImpl(AccountModule_skel.Account_skel):
    """ Implementation of the 'Account' interface. """

    def __init__(self):

	# Base class constructor.
	CORBA.Object_skel.__init__(self)

	self.m_balance = 123.4
	return

    def _get_balance(self):
	return self.m_balance

    def makeLodgement (self, f):
      self.m_balance = self.m_balance + f
#	return

    def makeWithdrawal (self, f):
      if f > self.m_balance:
          raise reject("not allowed")
      self.m_balance = self.m_balance - f
#      return


##########################################################################



def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    print 'Initialising the BOA...'

    # Initialise the BOA.
    boa = BOA.BOA_init(argv, BOA.BOA_ID)

    print 'Creating object reference...'

    # Create an object reference ('fred' is the object key).
    obj = boa.create('fred', AccountImpl._FNORB_ID)

    print 'Creating implementation...'

    # Create an instance of the implementation class.
    impl = AccountImpl()

    print 'Activating the implementation...'

    # Activate the implementation (ie. connect the generated object reference
    # to the implementation).  Note that the implementation will not receive
    # any operation requests until we start the event loop (see below).
    boa.obj_is_ready(obj, impl)

    # Write the stringified object reference to a file (this is just a 'cheap
    # and cheerful' way of making the object reference available to the
    # client!).
    open('server.ref', 'w').write(orb.object_to_string(obj))

    print 'Server created and accepting requests...'

    # Start the event loop.
    boa._fnorb_mainloop()

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################






