#! /bin/sh
# \
exec itclmicosh "$0" ${1+"$@"}

# file: AccountImpl.tcl


#
# require Itcl
#

package require Itcl

#
# Load MICO module, if not already available
#

if [catch {package require tclmico}] {
    load libtclmico[info sharedlibextension]
}

source account.tcl

class Account_impl {
    inherit POA_Account

    private variable balance 0

    public method makeLodgement { amount } {
	set balance [expr $balance + $amount]
    }

    public method makeWithdrawal { amount } {
	if {$amount > $balance} {
	    corba::throw {IDL:Account/reject:1.0 \
		    "Konto nicht gedeckt."}
	}
	set balance [expr $balance - $amount]
    }

    public method _get_balance {} {
	return $balance
    }
}
