#include <iostream.h>
#include <Windows.h>
#include <ole2.h>
#include "../Server/SysInfo.hpp"

#define _AFX_NO_BSTR_SUPPORT

// {885E7E70-71AA-11d2-84A0-006008540659}
static const GUID CLSID_SysInfo = 
{ 0x885e7e70, 0x71aa, 0x11d2, { 0x84, 0xa0, 0x0, 0x60, 0x8, 0x54, 0x6, 0x59 } };
// {885E7E71-71AA-11d2-84A0-006008540659}
static const GUID IID_ISysInfoFactory = 
{ 0x885e7e71, 0x71aa, 0x11d2, { 0x84, 0xa0, 0x0, 0x60, 0x8, 0x54, 0x6, 0x59 } };

int main()
{
 IMySysInfoFactory *pSysInfoFactory;
 IMySysInfo *m_pSysInfo;

 HRESULT hRes;

 CoInitialize(NULL);
 hRes = CoGetClassObject(CLSID_SysInfo, CLSCTX_SERVER, NULL,
	 IID_ISysInfoFactory, (void**) &pSysInfoFactory);
 if(FAILED(hRes))
 {
  cout << "Error " << hRes << " creating SysInfoFactory Object!" << endl;
  return FALSE;
 }

 hRes=pSysInfoFactory->CreateMySysInfo(&m_pSysInfo);
 if(FAILED(hRes))
 {
  cout << "Error " << hRes << " creating SysInfo Object!" << endl;
  return FALSE;
 }

 m_pSysInfo->GetSysInfo();
 m_pSysInfo->PrintSysInfo();
 pSysInfoFactory->Release();

 CoUninitialize();
 return TRUE;
}