#include "SysInfoImp.hpp"
#include <ole2.h>

// {885E7E70-71AA-11d2-84A0-006008540659}
static const GUID CLSID_SysInfo = 
{ 0x885e7e70, 0x71aa, 0x11d2, { 0x84, 0xa0, 0x0, 0x60, 0x8, 0x54, 0x6, 0x59 } };
// {885E7E71-71AA-11d2-84A0-006008540659}
static const GUID IID_ISysInfoFactory = 
{ 0x885e7e71, 0x71aa, 0x11d2, { 0x84, 0xa0, 0x0, 0x60, 0x8, 0x54, 0x6, 0x59 } };

long MySysInfoFactory::CreateMySysInfo(IMySysInfo** ppObject)
{
	*ppObject=(IMySysInfo*) new MySysInfo;
	return NO_ERROR;
}

unsigned long MySysInfoFactory::Release()
{
	delete this;
	return 0;
}

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, void ** ppObject)
{
	if (rclsid != CLSID_SysInfo)
		return CLASS_E_CLASSNOTAVAILABLE;
	if (riid != IID_ISysInfoFactory)
		return E_INVALIDARG;

	*ppObject=(IMySysInfoFactory*) new MySysInfoFactory;

	return NO_ERROR;
}

