/*
 * WelcomeRMIServer
 * Empfaengt den Namen als Parameter und gibt einen Antwortstring
 * zurueck 
 */


package welcome;

import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import java.util.Properties;
import javax.naming.InitialContext;
import java.rmi.RMISecurityManager;

public class WelcomeRMIServer extends PortableRemoteObject
  implements WelcomeRMI
{
  public WelcomeRMIServer () throws RemoteException
  {
  }

  public String message (String name)
  {
    System.out.println ("got request");
    return "Hallo " + name + ", wie geht es Dir?";
  }

  public static void main (String[] args)
  {
    try
    {
      if ( System.getSecurityManager() == null ) {
        System.setSecurityManager (new RMISecurityManager());
      }

      WelcomeRMIServer obj = new WelcomeRMIServer ();

      // Kontext fuer das Durchfuehren der Operationen setzen 
      // (InitialContext gehoert zu der Erweiterung von JNDI)
      InitialContext context = new InitialContext ();
      
      // bindet den Namen an das Objekt
      context.rebind ("WelcomeRMIServer", obj);
      System.out.println ("WelcomeRMIServer bound in registry");
    }
    catch (Exception e)
    {
      System.out.println ("WelcomeRMIServer Exception: " + e.getMessage());
      e.printStackTrace ();
    }
  }

}