# SMiner.pl
# Perl-Skript zur thematischen segmentierung von Nachrichtensendungen
#
# (c) Copyright 1999, Ramon Wartala (EMail: wartala@gmx.de)
# und Stephan Grell (EMail: grell@rz.fh-heilbronn.de)
# Version 1.0

use Getopt::Std;
use Win32::ODBC;
use Wrap_S2T;
use strict;

use vars qw($opt_p $opt_l $opt_t $opt_i $opt_o);

my $anzahlSegmente = 0;
my $pausenLaenge = 0;
my $pausenVolumen = 0;
my $inDatei = undef;
my $outDatei = undef;
my $text = undef;
my $audioDB = undef;
my $DSN = "AudioDB";            # Name der ODBC-Quelldatenbank
my $segmentURL = "";            # URL der Segment Audio-Datei
my $wavURL = "";                #
my $textDatei = "";             # Name der Textdatei eines Segmentes
my $index = 0;                  # Segment-Index
my $wort;
my $zeile;                      # Textdatei Zeile
my $sqlstat = "";
my $wortZeiger = undef;         # aktueller Datensatz-Zeiger fuer Tabelle 'WortTabelle'
my @alleWoerter = ();           # Alle Woerter einer Segment-Datei

if($#ARGV == -1) {
  print "Aufruf: SMiner.pl\n";
  print "\t-p Laenge der Pause zum kennzeichnen eines Segments\n";
  print "\t-l Lautstaerke einer Pause zur kennzeichnung eines Segments\n";
  print "\t-i Eingabe Dateiname\n";
  print "\t-o Ausgabe Dateiname\n";
  print "\t-t Zu erzeugende Textdatei(en)\n";
  print "Beispiel: SMiner.pl -p 13 -l 4000 -t text -i tagesschau.wav -o thema.wav\n";
  exit(-1);
} else {
	print "Starte SMiner...\n";
	
	#
	# Eingabe Argumente ermitteln...
	#
	getopts('p:l:i:o:t:');
}

# 
# ... und auswerten
#
if(($opt_p) && ($opt_l)) {
  $pausenLaenge = $opt_p;
  $pausenVolumen = $opt_l;
  Wrap_S2T::Pause_Definieren($pausenLaenge,$pausenVolumen);
} else {
	print "SMiner: Fehler: Sie muessen sowohl eine Pause (-p) als auch ein Volumen (-l) angeben!\n";
	exit(-1);
}

if(($opt_i) && ($opt_o)) {
  $inDatei = $opt_i;
  $outDatei = $opt_o;
  Wrap_S2T::Wav_Name_Setzen($inDatei,$outDatei);
} else {
	print "SMiner: Fehler: Sie muessen sowohl eine Eingabedatei (-i) als auch eine Ausgabedatei (-o) angeben!\n";
	exit(-1);
}
	
if($opt_t) {
  $text = $opt_t;
  Wrap_S2T::Text_Name_Setzen($text);
} else {
	print "SMiner: Fehler: Sie muessen den Ausgabenamen der Textdatei angeben!\n";
	exit(-1);
}

#
# Starte die Verarbeitung der Audio-Datei mit Hilfe von ViaVoice	  
#
$anzahlSegmente = Wrap_S2T::Starte_Verarbeitung();
if($anzahlSegmente < 0) {
	print "SMiner: Fehler: Bei der Bearbeitung ist ein Fehler $anzahlSegmente aufgetaucht\n";
	exit(-1);
}

print "\nAnzahl erzeugter Segmente:",$anzahlSegmente,"\n";

#
# Fuege erzeugte Audio-Segmente in die Datenbank ein
#
if (!($audioDB = new Win32::ODBC($DSN))){
  print "SMiner: Fehler: ",Win32::ODBC::Error(),"\n";
  exit(-1);
}else{
    print "Neue ODBC Verbindung ", $audioDB->Connection(), " zu Datenbank ",$DSN," aufgebaut\n\n";
	
	#
	# Ermittle den aktuellen Datensatzzeiger in Tabelle 'WortTabelle'
	#
	$audioDB->Sql("SELECT ID FROM WortTabelle");
	
	while($audioDB->FetchRow()){
		$wortZeiger = $audioDB->Data();
	}
	
	unless($wortZeiger) { $wortZeiger = 1 };
	
	#
	# Hauptschleife zum einfuegen der Daten in die Tabellen
	#
	
	$wavURL = "file://".$inDatei;
	
	for($index = 1; $index <= $anzahlSegmente;$index++) {
	
		if($index < 10) {
			$segmentURL = "file://".(substr $outDatei,0,(index $outDatei,".wav"))."_0".$index.".wav";
		} else {
			$segmentURL = "file://".(substr $outDatei,0,(index $outDatei,".wav"))."_".$index.".wav";
		}
		
		print "Fuege Segment Nr. ",$index," mit URL ",$segmentURL," in Datenbank ",$DSN," ein\n";
		$sqlstat = 'INSERT INTO SegmentTabelle VALUES ('.$index.',\''.$segmentURL.'\',\''.$wavURL.'\')';
		$audioDB->Sql($sqlstat);
		
		#
		# Woerter aus erzeugter Textdatei in die Wort Tabelle schreiben
		#
		if($index < 10) {
			$textDatei = $text."_0".$index.".txt";
		} else {
			$textDatei = $text."_".$index.".txt";
		}
		
		print "Oeffne $textDatei...\n";
		
		open(DATEI,$textDatei) or die "SMiner: Kann $textDatei nicht oeffnen!\n";;
		while(<DATEI>) {
			$zeile = $zeile.$_;
		}
		
		# Vorsicht! Zwischen den Woertern steht \0 und nicht ' '
		@alleWoerter = split "\0",$zeile;
	
		print "Fuege Woerter aus $textDatei in $DSN ein"; 
		foreach $wort (@alleWoerter) {
			# Fuege jedes Wort in die Datenbank-Tabelle 'WortTabelle' ein
			$sqlstat = 'INSERT INTO WortTabelle (ID,Nr,Wort) VALUES ('.$wortZeiger.','.$index.',\''.$wort.'\')';
			$audioDB->Sql($sqlstat);
			$wortZeiger++;
			print ".";
		}
		
		print "fertig\n";
		
		print "Schliesse Datei $textDatei\n";
		close DATEI;
	}
	
	print "Schliesse Datenbank $DSN\n";
	$audioDB->Close();
}





