# Spracherweiterung zur Erzeugung von Java-Code
# Autor: Oliver Boehm, olliboe@cs.tu-berlin.de, 1999

# assoziatives Array fr Html-Muster
%Patterns = ();

# assoziatives Array fr Funktionen/Methoden
%Procedures = ();

# Ausgabe
@output = ();

# wird beim Start des Parser aufgerufen
sub atBegin {
}

# wird vor Beendigung des Parser aufgerufen
sub atEnd {
    local ($tmp);

    # Generierung des #begin-Programmtext-Segmentes
    if (defined($Procedures{"#begin"})) {
	print $Procedures{"#begin"} ;
	undef($Procedures{"#begin"});
    }

    # Generierung der printPage()-Methode
    if (@output) {
	print "\tprivate void printPage() \{\n";

	foreach $tmp (@output) {
	    print $tmp;
	}

	print "\t}\n";
    }

    # Generierung von Methoden fr den Zugriff auf die Pattern
    visitHash(*Patterns, "evalPattern");

    # Generierung von Methoden fr bezeichnete <!-- exec > - Tags
    visitHash(*Procedures, "printProcedure");

    # Generierung des #end-Programmtext-Segmentes
    if (defined($Procedures{"#end"})) {
	print $Procedures{"#end"} ;
	undef($Procedures{"#end"});
    }

}

# wird vor dem Parsieren einer Datei aufgerufen
# $filename - Name der Datei
sub beforeFile {
    local ($filename) = @_;
}

# wird nach dem Parsieren einer Datei aufgerufen
# $filename - Name der Datei
sub afterFile {
    local ($filename) = @_;
}
   
# wird beim Auffinden eines <!-- pattern > - Tags aufgerufen
# $name      - Name des Pattern
# $paramList - Parameterliste der resultierenden Funktion/Methode
# $text      - Text des Pattern
sub atPattern {
    local ($name, $paramList, $text) = @_;    
    $Patterns{"$name\:$paramList"} = $text;
}

# wird beim  Auffinden von reinem Html-Text aufgerufen
# $text - Html-Text
sub atHTML {
    local ($text) = @_;
    $text =~ s/\"/\\\"/g;
    $text =~ s/\n/\\n/;
    $text =~ s/\t/\\t/;
    push (@output, "\t\tSystem.out.print(\"$text\");\n");
}

# wird beim Auffinden einer $Variablen$ aufgerufen
# $variable - Name der Variablen bzw. Text zwischen $..$
sub atVariable {
    local ($variable) = @_;
    push (@output, "\t\tSystem.out.print($variable);\n");
}

# wird beim Auffinden eines <!-- exec > - Tags aufgerufen
# $text - Programmtext
# $name - mglicher Bezeichner
sub atProgramText {
    local($text, $name) = @_;

    if ($name ne "") {
	if ($text =~ /\S/) {
	    # Programmtext mit Bezeichner als Prozedur speichern
	    $Procedures{$name} = $text;
	} else {
	    # Methodenaufruf generieren
	    push (@output, "\t\t$name();\n");
	}
    } else {
	push(@output, $text);
    }
}


# Ausgabe einer Methode
sub printProcedure {
    local ($name, $text) = @_;

    if ((length($text) > 0) && !($name =~ /^\#/)) {
	print "\n\n\tprivate void $name () \{\n";

	print $text;

	print "\t}\n";
    }
}

# Ausgabe eines Pattern
sub evalPattern {
    local($name, $text) = @_;
    local $parameList;
   
    open (OUT, "> JavaHtml.tmp") ||
	die "Can't open JavaHtml.tmp\n";
    print OUT $text;

    close OUT;

    ($name, $paramList) = split(/:/, $name);

    # Parameterliste
    if (($name =~ s|\#$||)) {
	# unterdrcken
	print "\n\n\tprivate void print_$name () \{\n";
    } else {
	# ausgeben
	print "\n\n\tprivate void print_$name ($paramList) \{\n";
    }

    # Pattern evaluieren
    if (length($text) > 0) {

	@output = ();

	evalFile(IN, "JavaHtml.tmp");

	foreach $tmp (@output) {
	    print $tmp;
	}
    }

    print "\t}\n";
}


1;
