#!/bin/perl

# maxi.pl - Prcompiler fr dynamische HTML-Dokumente
# Autor: Oliver Boehm, olliboe@cs.tu-berlin.de, 1999

require "getopts.pl";
&Getopts('m:f:c:vl:');

$execDir = $0;
$execDir =~ s#(\/|\\)[^\/\\]+$#$1#;

if (!$opt_m) {
    $opt_m = "$execDir"."uni.pm";
}

require "$opt_m";

if (!$opt_c) {
    $opt_c = "$execDir"."uni.cfg";
}

&atBegin();

foreach $html_file (@ARGV) {

    &beforeFile($html_file);

    evalFile("file00001", $html_file);

    &afterFile($html_file);

}

&atEnd();

# Html-Datei auswerten

sub evalFile {
    local ($handle, $filename) = @_;
    local $ret = "";
    local $follow = "";
    local $matched = "";
    local $name = "";

    $handle++;

    open ($handle, "< $filename") || 
	onerror ("Can\'t open file $filename\n");

    do  {
	
	# Beginn eines <!-- Tags suchen
	while (/\<!--\s*[^\>]+/) {

	    # Text davor ausgeben
	    evalText($`) if ($`);

	    # weiter mit dem Text einschlielich Token
	    $_ = $&.$';
	    $matched = $&;
	    $follow = $';

	    # Parsiere Programmtext
	    ($ret, $name) = parseExec($handle);
	    if ($ret || $name) {

		# Programmtext behandeln
		&atProgramText($ret, $name);
		next;
	    }

	    # Include von Files
	    $ret = parseInclude($handle);
	    if ($ret) {
		next;
	    }
	
	    # Parsiere Patterns
	    if ($ret = parsePattern($handle)) {
		next;
	    }
	    	    
	    # kein bekanntes Tag -> Tag ausgeben
	    &atHTML($matched);

	    # weiter mit dem Text nach dem Tag
	    $_ = $follow;
	}

	# Text ohne <!-- Tag ausgeben
	evalText($_) if ($_);

    } while (<$handle>);


    close $handle;
}

# wertet Html-Text aus
sub evalText {

    local ($str) = @_;
    local ($tmp) = "";
    local ($follow) = "";
    local ($var) = "";

    # Variable evaluieren
    while ($str =~ /(^|[^\\])\$([a-zA-Z](\\\$|[^\$])*)\$/) {
	$tmp = $`.$1;
	$var = $2;
	$follow = $';

	$tmp =~ s/\\(\$)/$1/g;
	$var =~ s/\\(\$)/$1/g;
    
	&atHTML($tmp);
	
	&atVariable($var);

	$str = $follow;
    }
    
    # HTML-Text drucken

    if ($str) {
	$str =~ s/\\(\$)/$1/g;
	&atHTML($str);
    }
}

# parsiert Html-Text von <tag> bis </tag>
sub parseTag {

    local ($handle, $tag) = @_;
    
    local $str = "";
    local $endTag = "";

    # Beginn des Tags
    if (/^\s*\<\s*($tag)(\s+|\>)/i) {
	$endTag = $1;
	$str = $&;
	$_ = $';
	
	# Ende des Tags
	while (!(/\<\/\s*$tag\s*\>/i)) {
	    $str .= $_;
	    last unless ($_ = <$handle>);
	}

	/\<\/\s*$endTag\s*\>/i;
	$str .= $`.$&;
	$_ = $';
    }
    return $str;
}

# parsiert <!-- pattern > - Tags
sub parsePattern {

    local ($handle) = @_;
    
    local $str = "";
    local $name = "";
    local $splitTag = "";
    local @splitNameList = ();
    local $tag = "";
    local $splitName = "";
    local $tmp = 0;
    local $paramList = "";
    local $w = '[a-zA-Z_\.0-9\#]';

    # Beginn des Pattern - Tag
    if (/^\s*\<!--\s*(pattern)\s+($w+)(\s+\((.*)\))?\s*--\>/i) {
	$name = $2;
	$paramList = $4;
	$_ = $';
	
	# Pattern bis zum /pattern - Tag lesen
        while (!(/<!--\s*\/(pattern)\s*--\>/i)){
	    
	    if (!@splitNameList && 
		/<!--\s*(split)\s+(\w+(\s+\w+)*)\s*\:\s*($w+(\s+$w+)*)\s*--\>/i) {
		$_ = $';
		$splitTag = join('|', split(/\s/,$2));
		@splitNameList = reverse(split(/\s/,$4));
	    }

	    # Anfang des Split-Tags suchen
	    if (@splitNameList && /\<\s*($splitTag)(\s+|\>)/i) {

		# Text vor dem ersten Split-Tag sichern
		$splitName = $name.'_'.pop(@splitNameList);

		# Pattern behandeln
		&atPattern($splitName, $paramList, $str);
		$str = "";
		$_ = $&.$';

		while (@splitNameList-1) {
		    # weiter Split-Tags suchen
		    if ($tag = parseTag($handle, $splitTag)) {
			$splitName = $name.'_'.pop(@splitNameList);

			# Pattern behandeln
			&atPattern($splitName, $paramList, $tag);
		    } else { 
			last unless ($_ = <$handle>);
		    }
		}

		$name = $name . '_' . pop(@splitNameList);
	    }

	    $str .= $_;
	    last unless ($_ = <$handle>);
	}

	# /pattern - Tag suchen
	/<!--\s*\/(pattern)\s*--\>/i;
	
	# Text vor dem Tag sichern
	$str .= $`;

	# weiter mit dem Text nach dem Tag
	$_ = $';
	
	# Pattern behandeln
	&atPattern($name, $paramList, $str);
    }
    return $name;
}

# parsiert <!-- exec > - Tag
sub parseExec {

    local ($handle) = @_;
    local $str = "";
    local $name = "";

    # Beginn des exec - Tags
    if (/^\s*\<!--\s+exec(\s+([a-zA-Z_\.0-9\#]+))?/i) {
	$name = $2;
	$_ = $';

	# Lesen bis zum Ende
	while (!(/--\>/)) {
	    $str .= $_;
	    last unless ($_ = <$handle>);
	}

        # Ende des Programmtextes suchen
	/\s*--\>/;

	# Text vor --> sichern
	$str .= $`;

	# weiter mit dem Text nach -->
	$_ = $';
    }

    return ($str, $name);
}

# parsiert <!-- #include > - Tag
sub parseInclude {

    local ($handle) = @_;
    local $str = "";
    local $follow = "";

    # #include - Tag suchen
    if (/^\s*\<!--\s+\#include\s+file\s*\=\s*\"(\S+)\"\s*--\>/i) {

	# Name des Include-Files
	$str = $1;

	# Text nach dem Tag sichern
	$follow = $';

	# Text lschen
	$_ = "";
	evalFile($handle, $str);

	# weiter mit dem Text nach dem #include - Tag
	$_ = $follow;
    }

    return $str;
}


# ruft fr jeden Eintrag eines assoziativen Arrays die Funktion
# $procedure auf und bergibt $key und $value als Parameter
# Hilfsfunktion fr die Spracherweiterung
sub visitHash {

    local(*hash, $procedure) = @_;
    local($key, $value);

    while (($key,$value) = each %hash) {
	eval "$procedure(\$key, \$value)";
    }
}

sub onerror {
    local ($msg) = @_;
    die $msg; 
}


sub getFile {
    return $opt_f;
}

sub getConfig {
    return $opt_c;
}

sub getLanguage {
    return $opt_l;
}
