# konfigurierbare Spracherweiterung
# Autor: Oliver Boehm, olliboe@cs.tu-berlin.de, 1999

# assoziatives Array fr Html-Muster
%Patterns = ();

# assoziatives Array fr Funktionen/Methoden
%Procedures = ();

# Puffer fr die Ausgabe
@patternStack = ();

# Konfiguration
%config = ();

# Werte zum Ersetzen der Konfigurationsmuster
%values = ();

# Struktur der Programmdatei
%fStructure = ();
@fIndex = ();

# wird beim Start des Parser aufgerufen
sub atBegin {
}

# wird vor Beendigung des Parser aufgerufen
sub atEnd {
}

# wird vor dem Parsieren einer Datei aufgerufen
# $html_file - Name der Html-Datei
sub beforeFile {
    local ($html_file) = @_;
    local($file, $configFile, $language);
    local ($html_base, $html_ext);
    local ($prog_base, $prog_ext);
    local($key, $value);

    # Name der Konfigurationsdatei
    $configFile = getConfig();
    if (defined($configFile)) {

	open (cfg, "< $configFile") || 
	    onerror ("Can\'t open file $configFile\n");

	# Konfiguration im AssocArray config speichern
	while (<cfg>) {
	    chop();
	    ($key, $value) = split(/\s*\:\s*/, $_);
	    if (defined($key) && defined($value)) {
		$key = lc($key);
		$key =~ s|\s||g;
		$config{$key} = $value;
	    }
	}
	
	close(cfg);
    }

    # Dateiname der Html-Datei aufspalten
    $html_base = $html_file;
    if ($html_base =~ /^\s*(\S+)\.(\S+)\s*$/) {
	$html_base = $1;
	$html_ext = $2;
    }
    $values{"html_base"} = $html_base;
    $values{"html_ext"} = $html_ext;

    # Programmdatei ffnen
    $file = getFile();
    if (defined($file)) {

	# Dateiname aufspalten
	$prog_base = $file;
	if ($prog_base =~ /^\s*(\S+)\.(\S+)\s*$/) {
	    $prog_base = $1;
	    $prog_ext = $2;
	    $config{"language"} = $prog_ext;
	}
	$values{"prog_base"} = $prog_base;
	$values{"prog_ext"} = $prog_ext;
    }

    # ausgewhlte Programmiersprache setzen
    $language = getLanguage();
    if (defined($language)) {
	$config{"language"} = $language;
    }

}

# wird nach dem Parsieren einer Datei aufgerufen
# $html_file - Name der Html-Datei
sub afterFile {
    local ($html_file) = @_;

    local ($tmp, $text, $len);
    local ($inFile, $outFile);
    local ($id) = "id00000";
    local ($name) = $id;
    local ($genDoc) = 0;
    local ($genPattern) = 0;
    local ($doEvaluation) = 0;

    # Programmdatei ffnen
    $inFile = getFile();

    if (!defined($inFile)) {
	generateDocument();
	visitHash(*Patterns, "evalPattern");
	return;
    }

    $outFile = $inFile;
    
    if (-r $inFile) {

	open (INatEND, "<$inFile") || 
	    onerror ("Can\'t open file $inFile\n");
	
	push(@fIndex, "$name\:");
	    
	while (<INatEND>) {
		
	    if(/\#\#\#\s*begin\s+gen(eration)?\s+of\s+(\w+)(\s+as\s+(\w+))?/) {
		$name = $2;
		push(@fIndex, "$2\:$4");
		next;
	    }

	    if(/\#\#\#\s*end\s+gen(eration)?/) {
		$name = ++$id;
		push(@fIndex, "$name\:");
		next;
	    }
	    if(/\#\#\#\s*begin\s+eval(uation)?/) {
		$doEvaluation++;
		next;
	    }
		
	    if(/\#\#\#\s*end\s+eval(uation)?/) {
		$doEvaluation = 0;
		next;
	    }
	    
	    if(/\#\#\#\s*gen(erate)?\s+(\w+)(\s+as\s+(\w+))?/) {
		$fStructure{"$2"} = "";
		push(@fIndex, "$2\:$4");
		
		$name = ++$id;
		push(@fIndex, "$name\:");
		next;
	    }
		
	    if (/\#\#\#\s*config(urate)?\s+([^\:\s]+)\s*\:\s*(.*)\s*$/) {
		$config{$2} = $3;
	    }
	    
	    $fStructure{$name} = "" if !(defined($fStructure{$name}));
	    
	    if ($doEvaluation > 0) {
		$_ = &evalString(*values, *config, "", $_); 
	    }
	    
	    $fStructure{$name} = $fStructure{$name}.$_;
	}

	close(INatEND);
    } else {
	$inFile = "";
    }
	
    if ($opt_v) {
	foreach $tmp (keys %config) {
	    print STDERR "config $tmp : ".$config{$tmp}."\n";
	}
    }

    if (defined($config{"output"})) {
	$outFile = &evalString(*values, *config, "output"); 
    }

    if ($outFile =~ /\S+/) {
	if ($inFile eq $outFile) {
	    $tmp = $values{"prog_base"}."\.mx";
	    $tmp .= "\.".$values{"prog_ext"} if (defined($values{"prog_ext"}));
	    rename($inFile, $tmp) ||
		onerror ("Can\'t rename $inFile to $tmp\n");
	}

	open (OUTatEND, ">$outFile") || 
	    onerror ("Can\'t open file $outFile to write\n");
	
	select OUTatEND;
    }


    if (@fIndex == 0) {
	generateDocument();
	visitHash(*Patterns, "evalPattern");
	return;
    }
   
    for ($i = 0; $i < @fIndex; $i++) {

	$tmp = $fIndex[$i];

	($name, $tmp) = split(/:/, $tmp);

	if ($name eq "document") {
	    generateDocument($tmp);
	    $genDoc++;
	    next;
	}

	if ($name eq "pattern") { 
	    visitHash(*Patterns, "evalPattern");
	    $genPattern++;
	    next;
	}

	if (length($Patterns{"$name"}) > 0) {
	    evalPattern($name, $Patterns{"$name"}, $tmp);
	    delete $Patterns{"$name"};
	    next;
	} 

	if (length($Procedures{"$name"}) > 0) {
	    printProcedur($name, $Procedures{"$name"}, $tmp);
	    delete $Procedures{"$name"};
	    next;
	} 


	if ($i+1 == @fIndex) {

	    print $fStructure{$name} if (@fIndex == 1);

	    if ($genDoc == 0) {
		generateDocument($tmp);
	    }

	    if ($genPattern == 0) {
		visitHash(*Patterns, "evalPattern") ;
	    }

	    visitHash(*Procedures, "printProcedure") ;
	}

	print $fStructure{$name} if (@fIndex > 1);
	    

    }
    
}

sub generateDocument {
    local($template) = @_;
    local($tmp, $text);

    # Generierung der printPage()-Methode
    $template = "document" if ($template eq "");

    $values{"text"} = "### begin generation of document as $template";
    print &evalString(*values, *config, "comment");
    
    $values{"text"} = $Patterns{"document"};
    print &evalString(*values, *config, $template);

    $values{"text"} = "### end generation";
    print &evalString(*values, *config, "comment");

    delete $Patterns{"document"};
}

# wird beim Auffinden eines <!-- pattern > - Tags aufgerufen
# $name      - Name des Pattern
# $paramList - Parameterliste der resultierenden Funktion/Methode
# $text      - Text des Pattern
sub atPattern {
    local ($name, $paramList, $text) = @_;    
    $Patterns{"$name"} = $text;
}

# wird beim  Auffinden von reinem Html-Text aufgerufen
# $text - Html-Text
sub atHTML {
    local ($text) = @_;
    $text =~ s/\"/\\\"/g;
    $text =~ s/\n/\\n/;
    $text =~ s/\t/\\t/;

    $values{"text"} = $text;
    $Patterns{"document"} =  $Patterns{"document"}.&evalString(*values, *config, "text");
}

# wird beim Auffinden einer $Variablen$ aufgerufen
# $variable - Name der Variablen bzw. Text zwischen $..$
sub atVariable {
    local ($variable) = @_;

    $values{"variable"} = $variable;
    $Patterns{"document"} .=  &evalString(*values, *config, "variable");
}

# wird beim Auffinden eines <!-- exec > - Tags aufgerufen
# $text - Programmtext
# $name - mglicher Bezeichner
sub atProgramText {
    local($text, $name) = @_;

    if ($name ne "") {
	if ($text =~ /\S/) {
	    # Programmtext mit Bezeichner als Prozedur speichern
	    $Procedures{$name} = $text;
	} else {
	    # Methodenaufruf generieren
	    $values{"name"} = $name;
	    $Patterns{"document"} .= &evalString(*values, *config, "call");
	}
    } else {
	$Patterns{"document"} .=  $text;
    }
}


# Ausgabe einer Methode
sub printProcedure {
    local ($name, $procText, $template) = @_;

    $template = "procedure" if ($template eq "");

    $values{"name"} = $name;
    if (length($procText) > 0) {
	$values{"text"} = "### begin generation of $name as $template";
	print &evalString(*values, *config, "comment");

	$values{"text"}  = $procText;
	print &evalString(*values, *config, $template);

	$values{"text"} = "### end generation";
	print &evalString(*values, *config, "comment");
    }
}

# Ausgabe eines Pattern
sub evalPattern {
    local($name, $text, $template) = @_;
    local $paramList, $tmp;

    if (length($text) == 0) {
	return;
    }

    $template = "pattern" if ($template eq "");
 
    open (OUT, "> maxi.tmp") ||
	die "Can't open maxi.tmp\n";
    print OUT $text;

    close OUT;

    # Pattern evaluieren
    push(@patternStack, $Patterns{"document"});
    $Patterns{"document"} = "";

    evalFile(IN, "maxi.tmp");

    $values{"text"} = "### begin generation of $name as $template";
    print &evalString(*values, *config, "comment");
    
    $values{"text"} = $Patterns{"document"};
    $values{"name"} = $name;
    $values{"paramlist"} = $paramList;
    print &evalString(*values, *config, $template);

    $values{"text"} = "### end generation";
    print &evalString(*values, *config, "comment");    

    $Patterns{"document"} = pop(@patternStack);
}

sub evalString {
    local (*arr, *config, $cKey, $pattern) = @_;
    local ($language) = $config{"language"};

    if (length($pattern) == 0) {
	$cKey = lc($cKey);
	if (defined($config{"$language\.$cKey"})) {
	    $pattern = $config{"$language\.$cKey"};
	} else {
	    $pattern = $config{$cKey};
	}
    }

    eval "\$pattern = \"$pattern\"";

    $pattern =~ s/(^|[^\\])(\#([a-zA-Z][a-zA-Z\_\.0-9]*)\#)/$1.$arr{$3}/ge;
    $pattern =~ s/\\(\#)/$1/g;
    return $pattern;
}

1;
