
import java.io.*;
import java.io.IOException;
import java.util.*;
import java.lang.*;
import java.text.*;

public class Bestellung extends Object {

  private Hashtable ht = null;
  private Date today = new Date(System.currentTimeMillis());
  private String date = DateFormat.getDateInstance().format(today);

  // Konstruktor
  public Bestellung () {
    ht = new Hashtable();

    // "Daten"
    ht.put("Toaster", "54.50" );
    ht.put("Fn", "15.30" );
    ht.put("Eierkocher", "25.80" );
    ht.put("Kaffeemaschine", "45.94" );
    ht.put("Waschmaschine", "999.95" );
  }

  public static void main(String args[]) {

    // Erzeugung des Objektes
    Bestellung bestellung = new Bestellung();
    bestellung.printPage();
    
  }


  // Methode zum Drucken der Tabelle
  // Wurde gekapselt, um mglichst viel Programmtext auszulagern
  public void printTable () {
    String key = null;
    String value = null;

    float fvalue = 0;
    float summe  = 0;
    java.text.DecimalFormat df = new java.text.DecimalFormat("#,##0.00");

    print_ArtikelTab_First();
    for ( Enumeration e = ht.keys(); e.hasMoreElements();) {

      key = (String) e.nextElement();
      value = (String) ht.get(key);
    
      fvalue = (new Float(value)).floatValue();

      print_ArtikelTab_Artikel(key, df.format(fvalue).toString());

      summe = summe + fvalue;
    }

    print_ArtikelTab_Summe(key, df.format(summe).toString());

    print_ArtikelTab_Last();

  }

	private void printPage() {
		System.out.print("<HTML>\n");
		System.out.print("\n");
		System.out.print("<HEAD>\n");
		System.out.print("\t<META NAME=\"Author\" Content=\"Oliver Boehm\">\n");
		System.out.print("\t<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;CHARSET=iso-8859-1\">\n");
		System.out.print("\t<TITLE>Bestellung</TITLE>\n");
		System.out.print("\t");
		System.out.print("<!-- Changed by: , 03-Aug-1999 --");
		System.out.print(">\n");
		System.out.print("</HEAD>\n");
		System.out.print("\n");
		System.out.print("<BODY>\n");
		System.out.print("\n");
		System.out.print("\n");
		System.out.print("\n");
		System.out.print("\n");
		System.out.print("<H1>\n");
		System.out.print("Ihre Bestellung vom ");
		System.out.print(date);
		System.out.print("\n");
		System.out.print("</H1>\n");
		System.out.print("\n");
		System.out.print(" \n");
 
  printTable();  
		System.out.print("\n");
		System.out.print("</BODY>\n");
		System.out.print("\n");
		System.out.print("</HTML>\n");
	}


	private void print_ArtikelTab_Artikel (String key, String value) {
		System.out.print("\t<TR>\n");
		System.out.print("\t	<TD><FONT COLOR=\"#400040\"><B>");
		System.out.print(key);
		System.out.print("</B></FONT></TD>\n");
		System.out.print("\t	<TD>\n");
		System.out.print("\t		<P ALIGN=\"RIGHT\"><FONT COLOR=\"#0000FF\"><B>");
		System.out.print(value);
		System.out.print(" DM</B></FONT>\n");
		System.out.print("\t	</TD>\n");
		System.out.print("\t</TR>");
	}


	private void print_ArtikelTab_Last () {
		System.out.print("\n");
		System.out.print("</TABLE>\n");
	}


	private void print_ArtikelTab_Summe (String key, String value) {
		System.out.print("<TR BGCOLOR=\"#FFFF00\" NOSAVE>\n");
		System.out.print("\t	<TD NOSAVE><FONT COLOR=\"#400040\"><B>Gesamt:</B></FONT></TD>\n");
		System.out.print("\t	<TD>\n");
		System.out.print("\t		<P ALIGN=\"RIGHT\"><FONT COLOR=\"#FF0000\"><B>");
		System.out.print(value);
		System.out.print(" DM</B></FONT>\n");
		System.out.print("\t	</TD>\n");
		System.out.print("\t</TR>");
	}


	private void print_ArtikelTab_First () {
		System.out.print("\n");
		System.out.print("\n");
		System.out.print("\n");
		System.out.print("<TABLE BORDER=\"1\" WIDTH=\"50%\" BGCOLOR=\"#FFFFFF\" COLS=\"2\" NOSAVE>\n");
	}

}
