import java.io.*;
import java.io.IOException;
import java.util.*;
import java.lang.*;
import java.text.*;

public class Bestellung extends Object {

  private Hashtable ht = null;
  private Date today = new Date(System.currentTimeMillis());
  private String date = DateFormat.getDateInstance().format(today);

  private String key = null;
  private  String value = null;
  private float summe  = 0;

  // Konstruktor
  public Bestellung () {
    ht = new Hashtable();

    // "Daten"
    ht.put("Toaster", "54.50" );
    ht.put("Fn", "15.30" );
    ht.put("Eierkocher", "25.80" );
    ht.put("Kaffeemaschine", "45.94" );
    ht.put("Waschmaschine", "999.95" );
  }

  public static void main(String args[]) {

    // Erzeugung des Objektes
    Bestellung bestellung = new Bestellung();
    PrintWriter pw = new PrintWriter(System.out);
    bestellung.printPage(pw);
    pw.flush();
  }


  // Methode zum Drucken der Tabelle
  // Wurde gekapselt, um mglichst viel Programmtext auszulagern
  public void printTable (PrintWriter out) {

    float fvalue = 0;
    java.text.DecimalFormat df = new java.text.DecimalFormat("#,##0.00");

    print_ArtikelTab_First(out);
    for ( Enumeration e = ht.keys(); e.hasMoreElements();) {

      key = (String) e.nextElement();
      value = (String) ht.get(key);
    
      fvalue = (new Float(value)).floatValue();

      print_ArtikelTab_Artikel(out, key,  df.format(fvalue).toString());

      summe = summe + fvalue;
    }

    print_ArtikelTab_Summe(out, df.format(summe).toString());

    print_ArtikelTab_Last(out);

  }


// ### begin generation of document as document 

public void printPage(PrintWriter out) {
	out.print("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n");
	out.print("<html>\n");
	out.print("<head>\n");
	out.print("   <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n");
	out.print("   <meta name=\"Author\" content=\"Oliver Boehm\">\n");
	out.print("   <meta name=\"GENERATOR\" content=\"Mozilla/4.5 [de] (Win98; I) [Netscape]\">\n");
	out.print("   <title>Bestellung</title>\n");
	out.print("   ");
	out.print("<!-- Changed by: , 24-Jul-1999 --");
	out.print(">\n");
	out.print("</head>\n");
	out.print("<body>\n");
	out.print("\n");
	out.print("<h1>\n");
	out.print("Ihre Bestellung vom ");
	out.print(date);
	out.print("</h1>\n");
	printTable(out);
	out.print("\n");
	out.print("</body>\n");
	out.print("</html>\n");

}
// ### end generation 

public void print_ArtikelTab_Summe(PrintWriter out, String summe) {

// ### begin generation of ArtikelTab_Summe as body 
	out.print("<tr BGCOLOR=\"#FFFFCC\" NOSAVE>\n");
	out.print("<td NOSAVE><b><font color=\"#400040\">Gesamt:</font></b></td>\n");
	out.print("\n");
	out.print("<td>\n");
	out.print("<div align=right><b><font color=\"#FF0000\">");
	out.print(summe);
	out.print(" DM</font></b></div>\n");
	out.print("</td>\n");
	out.print("</tr>");
// ### end generation 

}

// ### begin generation of ArtikelTab_First as pattern 

public void print_ArtikelTab_First(PrintWriter out) {
	out.print("\n");
	out.print("<table BORDER COLS=2 WIDTH=\"50%\" BGCOLOR=\"#FFFFFF\" NOSAVE >\n");

}
// ### end generation 

// ### begin generation of ArtikelTab_Last as pattern 

public void print_ArtikelTab_Last(PrintWriter out) {
	out.print("\n");
	out.print("</table>\n");

}
// ### end generation 

public void print_ArtikelTab_Artikel(PrintWriter out, String key, 
				     String value) {

// ### begin generation of ArtikelTab_Artikel as body 
	out.print("<tr>\n");
	out.print("<td><b><font color=\"#400040\">");
	out.print(key);
	out.print("</font></b></td>\n");
	out.print("\n");
	out.print("<td>\n");
	out.print("<div align=right><b><font color=\"#0000FF\">");
	out.print(value);
	out.print(" DM</font></b></div>\n");
	out.print("</td>\n");
	out.print("</tr>");
// ### end generation 

}

}
