#!/usr/bin/perl

#
# CGI-Modul und DB-Module einbinden, strict fr Variablendefinition
#
use CGI::Pretty ':standard',':html3';
use DBI;
use strict;

$SIG{__DIE__} = sub {print $_[0], end_html; exit(0)};

my $q = new CGI;
my $RDBMS = "mysql";  # Treibername mysql, Oracle, Informix etc.
my $DB = "Test";      # Database
my $user = "ck";      # Benutzer
my $password = undef; # Passwort
my $table = "gaestebuch";

print $q->header, $q->start_html(-title => "Gstebuch");

if (!$q->param()) {
  #
  # Script ohne Parameter aufgerufen: Formular ausgeben.
  #
  show_form($q);
} elsif (! $q->param("cancel")) {
  #
  # Script mit Parametern aufgerufen: Parameter rausholen
  #
  my ($oldmail,$id);
  my $vorname = $q->param("vorname");
  my $nachname = $q->param("nachname");
  my $email = $q->param("email");
  $q->dump();
  #
  # Keine EMail-Adresse -> Fehlermeldung.
  # Dito fr fehlenden Nachnamen
  #
  if (! $email)  {
    print "E-Mail-Adresse muss angegeben werden!\n";
    show_form($q);
    print $q->end_html;
    exit(0);
  }
  if (! $nachname)  {
    print "Nachname muss angegeben werden!\n";
    show_form($q);
    print $q->end_html;
    exit(0);
  }
  #
  # Verbindung zur DB aufbauen (siehe Parameter am Anfang des Scripts)
  #
  my $dbh = DBI->connect("DBI:$RDBMS:$DB",$user,$password) || 
    die "Konnte Datenbank $RDBMS\/$DB nicht ffnen";
  #
  # Nachgucken, ob schon ein Eintrag fr diese Vorname/Nachname-Kombination
  # in DB vorhanden ist
  #
  my $query = "select id, email from $table where " .
    "nachname = '$nachname' and vorname = '$vorname'";
  my $sth = $dbh->prepare($query) || 
    die "Fehler in SQL-Statement '$query': " . $dbh->errstr;

  #
  # Query ausfhren, 1. Ergebnis an $id und 2. an $oldmail binden
  #
  $sth->execute() ||
    die "Fehler beim Ausfhren von '$query': " . $dbh->errstr;
  $sth->bind_col(1,\$id) ||
    die "Fehler bei \"bind\" fr '$query': " . $dbh->errstr;
  $sth->bind_col(2,\$oldmail) ||
    die "Fehler bei \"bind\" fr '$query': " . $dbh->errstr;
  #
  # Ergebnis von DB abholen .
  #
  $sth->fetch();
  #
  # Drei Mglichkeiten:
  # 1. $oldmail ist nicht definiert -> Neuen Eintrag erzeugen
  # 2. $oldmail ist definiert und != $email -> Eintrag ndern
  # 3. $oldmail ist = $email -> nichts tun
  #
  if (!$oldmail) {
    #
    # Neuer Eintrag
    #
    $dbh->do("insert into $table (vorname, nachname, email) " .
             "values ('$vorname','$nachname','$email')");
    print "Wir haben Sie ins Gstebuch aufgenommen."
  } elsif ($oldmail ne $email)  {
    #
    # Alten Eintrag ndern
    #
    $dbh->do("update $table set email='$email' where id = $id");
    print "Wir haben Ihre E-Mail-Adresse gendert: " .
      "Vorher '$oldmail', jetzt '$email'."
  } else {
    #
    # Nichts tun
    #
    print "Sie sind bereits im Gstebuch eingetragen.";
  }
  $dbh->disconnect;
}

print $q->end_html;

#
# Subroutine zum Ausgeben des Formulars.
# Eine Table nimmt die Texte und Eingabefelder auf,
# damit das "schner" aussieht: Erste Spalte Texte, 
# zweite Spalte Eingabefelder. Die beiden Submit-Knpfe
# stehen unterhalb der Table.
#
sub show_form{
  my $q = shift;
  print $q->start_form(-method => "GET");
  print $q->table( $q->TR($q->td(["Vorname",
                                  textfield(-name => "vorname",
                                            -size => 25)
                                 ]
                                )
                         ),
                   $q->TR($q->td(["Nachname",
                                  textfield(-name => "nachname",
                                            -size => 25)
                                 ]
                                )
                         ),$q->TR($q->td(["E-Mail",
                                          textfield(-name => "email",
                                                    -size => 60)
                                         ]
                                        )
                                 )
                 );
  print $q->submit(-name => "submit", -value => "Eintragen");
  print $q->submit(-name => "cancel", -value => "Abbrechen");
  print $q->end_form;
}
