Attribute VB_Name = "modCOmAdmin"
' ========================================
' Automatisierte COM+ Administration
' Autor: Holger Schwichtenberg (hs@it-visions.de)
' Version: 1.0
' Stand: 17.12.1999
' ========================================


Sub comcat1()
Dim objCAT As COMAdminCatalog
Dim colApps As COMAdmin.COMAdminCatalogCollection
Dim colComs As COMAdmin.COMAdminCatalogCollection
Dim colInt As COMAdmin.COMAdminCatalogCollection
Dim objApp As COMAdmin.COMAdminCatalogObject
Dim objCOM As COMAdmin.COMAdminCatalogObject
Dim objINT As COMAdmin.COMAdminCatalogObject

Dim c As Integer ' Zhler fr die Komponenten
Dim a As Integer ' Zhler fr die Applications

Set objCAT = CreateObject("COMAdmin.COMAdminCatalog.1")

' Zugriff auf Applications-Collection
Set colApps = objCAT.GetCollection("Applications")
colApps.Populate

' Iteration ber Applications
say "Anzahl der COM+-Anwendungen:" & colApps.Count
For a = 0 To colApps.Count - 1
    Set objApp = colApps.Item(a)
    say a + 1 & ":" & objApp.Name
    
    ' Zugriff auf Klassen-Collection
    Set colComs = colApps.GetCollection("Components", objApp.Key)
    colComs.Populate
    
    ' Iteration ber Klassen
    say "enthaltene Komponenten: " & colComs.Count
    For c = 0 To colComs.Count - 1
        Set objCOM = colComs.Item(c)
        say "     " & c + 1 & ":" & objCOM.Name
        
         ' Zugriff auf Schnittstellen
        Set colInt = colComs.GetCollection("InterfacesForComponent", objCOM.Key)
        colInt.Populate
        ' Iteration ber Schnittstellen
        For I = 0 To colInt.Count - 1
            Set objINT = colInt.Item(I)
            say "       - " & I + 1 & ":" & objINT.Name
        Next
    Next
Next
say "---"
End Sub

' Installation einer MSI-Anwendung
Sub comcat2()
Dim objCAT As COMAdminCatalog
Set objCAT = CreateObject("COMAdmin.COMAdminCatalog.1")

objCAT.InstallApplication "c:\dev\mts\code\transdemo\transdemo_msi\transdemoapp.msi"
End Sub
