/*
 * Decompiled with CFR 0.152.
 */
package de.ebuchner.jv;

import de.ebuchner.jv.AboutBox;
import de.ebuchner.jv.JvEntryPanel;
import de.ebuchner.jv.JvTree;
import de.ebuchner.jv.ManifestPanel;
import de.ebuchner.jv.TreeDGAdapter;
import de.ebuchner.jv.TreeDTAdapter;
import de.ebuchner.util.SimpleFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class JvFrame
extends JFrame {
    JMenuBar menuBar = new JMenuBar();
    JMenu menuFile = new JMenu();
    JMenuItem menuFileOpen = new JMenuItem();
    JMenuItem menuFileExit = new JMenuItem();
    JMenu menuHelp = new JMenu();
    JMenuItem menuHelpAbout = new JMenuItem();
    JToolBar toolBar = new JToolBar();
    JButton openBtn = new JButton();
    JButton helpBtn = new JButton();
    ImageIcon imgOpen;
    ImageIcon imgHelp;
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane treePane = new JScrollPane();
    JvTree jvTree = new JvTree();
    String startDir;
    static final String APP_TITLE = "Jar Viewer";
    JSplitPane splitter = new JSplitPane();
    JvEntryPanel entryPanel = new JvEntryPanel();
    ManifestPanel manifestPanel = new ManifestPanel();
    JTabbedPane tabbedPane = new JTabbedPane();

    public JvFrame() {
        this(".");
    }

    public JvFrame(String string) {
        this.startDir = string;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.jvTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    JarEntry jarEntry = JvFrame.this.jvTree.getSelectedEntry();
                    Manifest manifest = null;
                    try {
                        manifest = JvFrame.this.jvTree.getJarFile().getManifest();
                    }
                    catch (IOException iOException) {}
                    if (jarEntry != null) {
                        JvFrame.this.entryPanel.show(jarEntry);
                        JvFrame.this.manifestPanel.show(manifest, jarEntry);
                    }
                }
            });
            this.initDnD();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    public void helpAbout_actionPerformed(ActionEvent actionEvent) {
        AboutBox aboutBox = new AboutBox(this);
        Dimension dimension = aboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        ((Component)aboutBox).setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        aboutBox.setModal(true);
        aboutBox.show();
    }

    private void initDnD() {
        new TreeDGAdapter(this.jvTree);
        new TreeDTAdapter(this.jvTree);
    }

    private void jbInit() throws Exception {
        try {
            this.imgOpen = new ImageIcon(this.getClass().getResource("openFile.gif"));
            this.imgHelp = new ImageIcon(this.getClass().getResource("help.gif"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getContentPane().setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(640, 480));
        this.setTitle(APP_TITLE);
        this.menuFile.setText("File");
        this.menuFileOpen.setText("Open...");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JvFrame.this.openBtn_actionPerformed(actionEvent);
            }
        };
        this.menuFileOpen.addActionListener(actionListener);
        this.menuFileExit.setText("Exit");
        this.menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JvFrame.this.fileExit_actionPerformed(actionEvent);
            }
        });
        this.menuHelp.setText("Help");
        this.menuHelpAbout.setText("About");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JvFrame.this.helpAbout_actionPerformed(actionEvent);
            }
        };
        this.menuHelpAbout.addActionListener(actionListener2);
        this.openBtn.setIcon(this.imgOpen);
        this.openBtn.addActionListener(actionListener);
        this.openBtn.setToolTipText("Open File");
        this.helpBtn.setIcon(this.imgHelp);
        this.helpBtn.addActionListener(actionListener2);
        this.helpBtn.setToolTipText("About JarView");
        this.toolBar.add(this.openBtn);
        this.toolBar.add(this.helpBtn);
        this.menuFile.add(this.menuFileOpen);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileExit);
        this.menuHelp.add(this.menuHelpAbout);
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.splitter, "Center");
        this.splitter.add((Component)this.tabbedPane, "top");
        this.splitter.setLeftComponent(this.treePane);
        this.splitter.setRightComponent(this.tabbedPane);
        this.tabbedPane.add("JarEntry", this.entryPanel);
        this.tabbedPane.add("Manifest", this.manifestPanel);
        this.treePane.getViewport().add((Component)this.jvTree, null);
        this.splitter.setDividerLocation(200);
    }

    void openBtn_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.startDir);
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter("Archives (*.jar, *.zip)");
        simpleFileFilter.addExt("jar");
        simpleFileFilter.addExt("zip");
        jFileChooser.addChoosableFileFilter(simpleFileFilter);
        if (jFileChooser.showOpenDialog(this) != 0) {
            return;
        }
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                File file = jFileChooser.getSelectedFile();
                this.jvTree.show(file);
                this.setTitle("Jar Viewer - " + file.getAbsolutePath());
                this.manifestPanel.show(this.jvTree.getJarFile().getManifest());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "File Error", 0);
            }
            Object var5_6 = null;
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.fileExit_actionPerformed(null);
        }
    }
}

