/*
 * Decompiled with CFR 0.152.
 */
package de.ebuchner.jv;

import de.ebuchner.jv.JvTreeModel;
import de.ebuchner.jv.JvTreeNode;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class JvTree
extends JTree {
    JarFile jarFile = null;

    public JvTree() {
        super(new JvTreeModel());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public JvTree(JarFile jarFile) {
        this();
        this.show(jarFile);
    }

    private JarEntry entryOf(TreePath treePath) {
        JarEntry jarEntry = ((JvTreeNode)treePath.getLastPathComponent()).entry();
        if (jarEntry == null || jarEntry.isDirectory()) {
            return null;
        }
        return jarEntry;
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    public JarEntry getSelectedEntry() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        JvTreeNode jvTreeNode = (JvTreeNode)treePath.getLastPathComponent();
        return jvTreeNode.entry();
    }

    public JarEntry[] getSelectionEntries() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        JarEntry[] jarEntryArray = new JarEntry[treePathArray.length];
        int n = 0;
        while (n < treePathArray.length) {
            jarEntryArray[n] = this.entryOf(treePathArray[n]);
            ++n;
        }
        return jarEntryArray;
    }

    public void show(File file) throws IOException {
        this.show(new JarFile(file));
    }

    public void show(JarFile jarFile) {
        this.jarFile = jarFile;
        JvTreeModel jvTreeModel = (JvTreeModel)this.getModel();
        jvTreeModel.show(jarFile);
    }
}

