package de.ebuchner.je;

import java.awt.Component;
import java.io.*;
import javax.swing.*;
import javax.swing.tree.*;

/**
 * Treeknoten, der einem Verzeichnis entspricht
 */
public class DirNodeRenderer extends DefaultTreeCellRenderer  {

  public DirNodeRenderer() {
    super();
    // Default JTree ist fast perfekt - nur sollten Verzeichnisse auch so aussehen
    setLeafIcon(UIManager.getIcon("Tree.closedIcon"));
  }

  /**
   * Gibt den Namen der Datei oder des Verzeichnisses aus
   */
  public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
    DirTreeModel model = (DirTreeModel)tree.getModel();
    File f = model.fileOf(value);

    return super.getTreeCellRendererComponent(tree, JeUtils.nameOf(f), selected, expanded, leaf, row, hasFocus);
  }
}
