package de.ebuchner.je;

import java.io.File;
import java.util.*;
import javax.swing.tree.*;

public class DirTreeModel extends DefaultTreeModel {

  // Root-Knoten. Entspricht "My Computer" unter Win
  private static final DefaultMutableTreeNode myComputer = new DefaultMutableTreeNode(null);

  // Cache
  private HashMap cache = new HashMap();

  /**
   * C'tor
   */
  public DirTreeModel() {
    super(myComputer);
  }

  /**
   * Rootknoten
   */
  public Object getRoot() {
    return myComputer;
  }

  public Object getChild(Object parent, int index) {
    Object [] children = listFiles(fileOf(parent));
    DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(children[index]);
    return dmtn;
  }

  public int getChildCount(Object parent) {
    Object [] children = listFiles(fileOf(parent));
    return children.length;
  }

  public boolean isLeaf(Object node) {
    Object [] children = listFiles(fileOf(node));
    return children.length==0;
  }

  public void valueForPathChanged(TreePath path, Object newValue) {
    //TODO
  }

  public int getIndexOfChild(Object parent, Object child) {
    Object [] children = listFiles(fileOf(parent));
    File f = fileOf(child);
    for(int i=0; i<children.length; i++) {
      if (f.equals(children[i]))
        return i;
    }
    throw new IllegalArgumentException(child + " is not a child of " + parent);
  }

  /**
   * Liefert den Inhalt eines Verzeichnisses.
   * SecurityException wird abgefangen.
   * Bug unter NT: MsgBox wg. Diskettenlaufwerk
   * @param dir Verzeichnis oder null fuer Filesystem-Roots
   */
  private Object [] listFiles(File dir) {
    boolean showHidden = false;

    Object [] files = (Object[])cache.get(dir);
    if(files!=null)
      return files;

    try {
      if(dir==null) {
        files = File.listRoots();
        showHidden = true; // NT: NTFS-Partitionen sind hidden???
      }
      else
        files = dir.listFiles();
    } catch(SecurityException e) {
      // Wird nicht angezeigt
    }

    if (files == null)
      files = JeUtils.NO_FILES;
    else
      files = JeUtils.extract(files, JeUtils.TYPE_DIR, true/*sort*/, showHidden);

    cache.put(dir, files);
    return files;
  }

  /**
   * Welchem File entspricht ein Tree-Knoten?
   * @param dmtnObj instanceof DMTreeNode
   * @return File oder null fuer "My Computer"
   */
  public static File fileOf(Object dmtnObj) {
    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)dmtnObj;
    File f = (File)dmtn.getUserObject();
    return f;
  }
}
