package de.ebuchner.dnd;

import java.awt.Cursor;
import java.awt.dnd.*;

/**
 * Die Klasse sorgt fuer das User-Feedback waehrend
 * des Draggings. Abhaengig vom User und den Aktionen
 * die Quelle und Ziel unterstuetzen wird der Mauszeiger
 * umgeschalten
 */
public class DragSourceAdapter implements DragSourceListener {

  /**
   * Der Anwender zieht die Dateien in eine
   * drop-faehige GUI-Komponente hinein
   */
  public void dragEnter(DragSourceDragEvent dsde) {
    DragSourceContext context= dsde.getDragSourceContext();
    context.setCursor(cursor(dsde));
  }

  /**
   * Der Anwender zieht die Dateien UEBER eine
   * drop-faehige GUI-Komponente
   */
  public void dragOver(DragSourceDragEvent dsde) {
    DragSourceContext context= dsde.getDragSourceContext();
    context.setCursor(cursor(dsde));
  }

  /**
   * Der Anwender wechselt die Aktion
   */
  public void dropActionChanged(DragSourceDragEvent dsde) {
    DragSourceContext context= dsde.getDragSourceContext();
    context.setCursor(cursor(dsde));
  }

  /**
   * Der Anwender verlaesst die GUI-Komponente
   */
  public void dragExit(DragSourceEvent dse) {
  }

  /**
   * Benachrichtigung ueber das Ende des Drop-Vorgangs
   */
  public void dragDropEnd(DragSourceDropEvent dsde) {
  }

  /**
   * Hilfsroutine, die den passenden Cursor ermittelt
   */
  private Cursor cursor(DragSourceDragEvent dsde) {
    Cursor cursor;

    // Welche Aktion hat der Anwender gerade ausgewaehlt?
    int userAction = dsde.getUserAction();

    // User-Action oder ACTION_NONE falls Quelle und/oder Ziel die
    // ausgewaehlte Aktion nicht unterstuetzen
    int dropAction = dsde.getDropAction();

    switch(userAction) {
      case DnDConstants.ACTION_COPY:
        cursor = dropAction == DnDConstants.ACTION_NONE ?
                 DragSource.DefaultCopyNoDrop : DragSource.DefaultCopyDrop;
        break;
      case DnDConstants.ACTION_MOVE:
        cursor = dropAction == DnDConstants.ACTION_NONE ?
                 DragSource.DefaultMoveNoDrop : DragSource.DefaultMoveDrop;
        break;
      case DnDConstants.ACTION_LINK:
        cursor = dropAction == DnDConstants.ACTION_NONE ?
                 DragSource.DefaultLinkNoDrop : DragSource.DefaultLinkDrop;
        break;
      default:
        throw new RuntimeException("Unknown userAction " + userAction);
    }
    return cursor;
  }
}
