package de.ebuchner.je;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;

public class JeFrame extends JFrame {

  // GUI-Master
  JeDirector director;

  // GUI
  JMenuBar menuBar1 = new JMenuBar();
  JMenu menuFile = new JMenu();
  JMenuItem menuFileExit = new JMenuItem();
  JMenu menuOptions = new JMenu();
  JCheckBoxMenuItem menuOptionHidden = new JCheckBoxMenuItem();
  JMenu menuHelp = new JMenu();
  JMenuItem menuHelpAbout = new JMenuItem();
  JLabel statusBar = new JLabel();
  BorderLayout borderLayout1 = new BorderLayout();
  JSplitPane splitter = new JSplitPane();
  JScrollPane dirTreePane = new JScrollPane();
  JScrollPane fileTablePane = new JScrollPane();
  DirTree dirTree = new DirTree();
  FileTable fileTable = new FileTable();

  /**
   * C'tor
   */
  public JeFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try  {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }

    // Uebernimmt die Regie
    director = new JeDirector(this, dirTree, fileTable);
  }

  //Component initialization
  private void jbInit() throws Exception  {
    this.getContentPane().setLayout(borderLayout1);
    this.setSize(new Dimension(640, 480));
    this.setTitle("JExplorer");
    statusBar.setText(" ");

    menuFile.setText("File");
    menuFileExit.setText("Exit");
    menuFileExit.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        fileExit_actionPerformed(e);
      }
    });

    menuOptions.setText("Options");
    menuOptionHidden.setText("Show Hidden Files");
    menuOptionHidden.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        optionHidden_actionPerformed(e);
      }
    });

    menuHelp.setText("Help");
    menuHelpAbout.setText("About");
    menuHelpAbout.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        helpAbout_actionPerformed(e);
      }
    });

    menuFile.add(menuFileExit);
    menuOptions.add(menuOptionHidden);
    menuHelp.add(menuHelpAbout);

    menuBar1.add(menuFile);
    menuBar1.add(menuOptions);
    menuBar1.add(menuHelp);

    this.setJMenuBar(menuBar1);
    this.getContentPane().add(statusBar, BorderLayout.SOUTH);
    this.getContentPane().add(splitter, BorderLayout.CENTER);
    splitter.add(dirTreePane, JSplitPane.LEFT);
    splitter.add(fileTablePane, JSplitPane.RIGHT);
    splitter.setDividerLocation(200);

    dirTreePane.getViewport().add(dirTree, null);
    fileTablePane.getViewport().add(fileTable, null);
    fileTablePane.setBackground(fileTable.getBackground());
  }

  //File | Exit action performed
  public void fileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }

  //Options | Show hidden action performed
  public void optionHidden_actionPerformed(ActionEvent e) {
    director.setHiddenShown(menuOptionHidden.isSelected());
  }

  //Help | About action performed
  public void helpAbout_actionPerformed(ActionEvent e) {
    AboutBox dlg = new AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }

  //Overridden so we can exit on System Close
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if(e.getID() == WindowEvent.WINDOW_CLOSING) {
      fileExit_actionPerformed(null);
    }
  }

  public void setStatus(String text) {
    statusBar.setText(text);
  }
}
