package de.ebuchner.jv;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.jar.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

import de.ebuchner.util.SimpleFileFilter;

/**
 * Hauptfenster von JarView.
 * Generiert mit JBuilder 3.5 Foundation
 */
public class JvFrame extends JFrame {
  JMenuBar menuBar = new JMenuBar();
  JMenu menuFile = new JMenu();
  JMenuItem menuFileOpen = new JMenuItem();
  JMenuItem menuFileExit = new JMenuItem();
  JMenu menuHelp = new JMenu();
  JMenuItem menuHelpAbout = new JMenuItem();
  JToolBar toolBar = new JToolBar();
  JButton openBtn = new JButton();
  JButton helpBtn = new JButton();
  ImageIcon imgOpen;
  ImageIcon imgHelp;
  BorderLayout borderLayout1 = new BorderLayout();
  JScrollPane treePane = new JScrollPane();
  JvTree jvTree = new JvTree();

  String startDir;

  final static String APP_TITLE = "Jar Viewer";
  JSplitPane splitter = new JSplitPane();
  JvEntryPanel entryPanel = new JvEntryPanel();
  ManifestPanel manifestPanel = new ManifestPanel();
  JTabbedPane tabbedPane = new JTabbedPane();

  //Construct the frame
  public JvFrame() {
    this(".");
  }

  public JvFrame(String startDir) {
    this.startDir = startDir;

    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try  {
      jbInit();

      // TSL sorgt dafuer, dass die Panels synchron zur
      // Auswahl im Tree bleiben
      jvTree.addTreeSelectionListener(new TreeSelectionListener() {
        public void valueChanged(TreeSelectionEvent e) {
          JarEntry entry = jvTree.getSelectedEntry();
          Manifest manifest = null;
          try {
            manifest = jvTree.getJarFile().getManifest();
          } catch(IOException io) {
          }

          if(entry!=null) {
            entryPanel.show(entry);
            manifestPanel.show(manifest, entry);
          }
        }
      });

      // DnD-Support
      initDnD();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Initialisierung DnD
   */
  private void initDnD() {
    // Drag-Fhigkeit
    new TreeDGAdapter(jvTree);
    // Drop-Fhigkeit
    new TreeDTAdapter(jvTree);
  }

  //Component initialization
  private void jbInit() throws Exception  {
    try {
      imgOpen = new ImageIcon(getClass().getResource("openFile.gif"));
      imgHelp = new ImageIcon(getClass().getResource("help.gif"));
    } catch(Exception e) {
      // JB3.5 Linux: Kopiert die Images nicht mehr nach lib
      e.printStackTrace();
    }
    this.getContentPane().setLayout(borderLayout1);
    this.setSize(new Dimension(640, 480));
    this.setTitle(APP_TITLE);

    menuFile.setText("File");
    menuFileOpen.setText("Open...");
    ActionListener openL = new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        openBtn_actionPerformed(e);
      }
    };
    menuFileOpen.addActionListener(openL);

    menuFileExit.setText("Exit");
    menuFileExit.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        fileExit_actionPerformed(e);
      }
    });

    menuHelp.setText("Help");
    menuHelpAbout.setText("About");
    ActionListener aboutL = new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        helpAbout_actionPerformed(e);
      }
    };
    menuHelpAbout.addActionListener(aboutL);

    openBtn.setIcon(imgOpen);
    openBtn.addActionListener(openL);
    openBtn.setToolTipText("Open File");

    helpBtn.setIcon(imgHelp);
    helpBtn.addActionListener(aboutL);
    helpBtn.setToolTipText("About JarView");

    toolBar.add(openBtn);
    toolBar.add(helpBtn);

    menuFile.add(menuFileOpen);
    menuFile.addSeparator();
    menuFile.add(menuFileExit);

    menuHelp.add(menuHelpAbout);

    menuBar.add(menuFile);
    menuBar.add(menuHelp);

    this.setJMenuBar(menuBar);
    this.getContentPane().add(toolBar, BorderLayout.NORTH);
    this.getContentPane().add(splitter, BorderLayout.CENTER);
    splitter.add(tabbedPane, JSplitPane.TOP);
    splitter.setLeftComponent(treePane);
    splitter.setRightComponent(tabbedPane);
    tabbedPane.add("JarEntry", entryPanel);
    tabbedPane.add("Manifest", manifestPanel);
    treePane.getViewport().add(jvTree, null);
    splitter.setDividerLocation(200);
  }

  //File | Exit action performed
  public void fileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }

  //Help | About action performed
  public void helpAbout_actionPerformed(ActionEvent e) {
    AboutBox dlg = new AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }

  //Overridden so we can exit on System Close
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if(e.getID() == WindowEvent.WINDOW_CLOSING) {
      fileExit_actionPerformed(null);
    }
  }

  void openBtn_actionPerformed(ActionEvent e) {
    JFileChooser fc = new JFileChooser(startDir);

    // jar- and zip-Extension (NT-spezifisch)
    SimpleFileFilter filter = new SimpleFileFilter("Archives (*.jar, *.zip)");
    filter.addExt("jar");
    filter.addExt("zip");
    fc.addChoosableFileFilter(filter);

    if(JFileChooser.APPROVE_OPTION != fc.showOpenDialog(this))
      return;

    try {
      setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
      File f = fc.getSelectedFile();
      jvTree.show(f);
      setTitle(APP_TITLE + " - " + f.getAbsolutePath());
      manifestPanel.show(jvTree.getJarFile().getManifest());
    } catch(IOException io) {
      JOptionPane.showMessageDialog(
        this,
        io.getMessage(),
        "File Error",
        JOptionPane.ERROR_MESSAGE
      );
    } finally {
      setCursor(Cursor.getDefaultCursor());
    }
  }
}
