package de.ebuchner.util;

import javax.swing.*;

import java.io.File;
import java.util.*;
import javax.swing.filechooser.FileFilter;

/**
 * Code i.W. aus dem Swing-Tutorial
 */
public class SimpleFileFilter extends javax.swing.filechooser.FileFilter {

  HashSet exts = new HashSet();
  String  desc;

  public SimpleFileFilter(String desc) {
    this.desc = desc;
  }

  public SimpleFileFilter(String ext, String desc) {
    addExt(ext);
    this.desc = desc;
  }

  public void addExt(String ext) {
    exts.add(ext);
  }

  /**
   * Akzeptiert Verzeichnisse und Dateien mit der richtigen Endung
   */
  public boolean accept(File f) {
    if (f.isDirectory())
      return true;

    boolean accept=false;

    // Endung der aktuellen Datei
    String fileExt = getExtension(f);

    for(Iterator it=exts.iterator(); !accept && it.hasNext(); ) {
      String ext = (String)it.next();
      if (fileExt != null) {
        if (fileExt.toLowerCase().equals(ext))
          accept=true;
      }
    }

    return accept;
  }

  // The description of this filter
  public String getDescription() {
    return desc;
  }

  // Aus Java Swing Tutorial
  static final String getExtension(File f) {
    String ext = null;
    String s = f.getName();
    int i = s.lastIndexOf('.');

    if (i > 0 &&  i < s.length() - 1) {
      ext = s.substring(i+1).toLowerCase();
    }
    return ext;
  }
}
