/*
 * Decompiled with CFR 0.152.
 */
package de.ebuchner.je;

import de.ebuchner.je.DirTree;
import de.ebuchner.je.FileTable;
import de.ebuchner.je.JeDGAdapter;
import de.ebuchner.je.JeDTAdapter;
import de.ebuchner.je.JeFrame;
import java.awt.Cursor;
import java.io.File;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class JeDirector
implements TreeSelectionListener {
    JeFrame frame;
    DirTree tree;
    FileTable table;

    public JeDirector(JeFrame jeFrame, DirTree dirTree, FileTable fileTable) {
        this.frame = jeFrame;
        this.tree = dirTree;
        this.table = fileTable;
        dirTree.addTreeSelectionListener(this);
        new JeDGAdapter(fileTable);
        new JeDTAdapter(dirTree, this);
        new JeDTAdapter(fileTable, this);
    }

    public File getCwd() {
        return this.tree.getCwd();
    }

    public void refresh() {
        this.table.setCwd(this.tree.getCwd());
    }

    public void setHiddenShown(boolean bl) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource() == this.tree) {
            File file = this.tree.getCwd();
            if (file == null) {
                this.frame.setStatus("");
                this.table.setCwd(null);
            } else {
                this.frame.setCursor(Cursor.getPredefinedCursor(3));
                this.frame.setStatus(file.getAbsolutePath());
                this.table.setCwd(file);
                this.frame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

