/*
 * Decompiled with CFR 0.152.
 */
package de.ebuchner.jv;

import de.ebuchner.jar.JarUtils;
import de.ebuchner.jv.JvTreeNode;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class JvTreeModel
extends DefaultTreeModel {
    static JvTreeNode root = new JvTreeNode("(no file loaded)");

    public JvTreeModel() {
        this((JarFile)null);
    }

    public JvTreeModel(JarFile jarFile) {
        super(root);
        if (jarFile != null) {
            this.show(jarFile);
        }
    }

    private void addEntry(DefaultMutableTreeNode defaultMutableTreeNode, JarEntry jarEntry) {
        Enumeration enumeration = JarUtils.splitName(jarEntry);
        if (enumeration.hasMoreElements()) {
            this.addEntry(defaultMutableTreeNode, jarEntry, enumeration);
        }
    }

    private void addEntry(DefaultMutableTreeNode defaultMutableTreeNode, JarEntry jarEntry, Enumeration enumeration) {
        String string = (String)enumeration.nextElement();
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.findNode(defaultMutableTreeNode, string);
        if (enumeration.hasMoreElements()) {
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = new JvTreeNode(string);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.addEntry(defaultMutableTreeNode2, jarEntry, enumeration);
        } else {
            defaultMutableTreeNode.add(new JvTreeNode(jarEntry, string));
        }
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode2.getUserObject().equals(string)) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    public void show(JarFile jarFile) {
        root.setUserObject(jarFile.getName());
        while (this.getChildCount(root) > 0) {
            this.removeNodeFromParent((DefaultMutableTreeNode)this.getChild(root, 0));
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            this.addEntry(root, jarEntry);
        }
        super.nodeStructureChanged(root);
    }
}

