package de.ebuchner.jv;

import javax.swing.UIManager;
import java.awt.*;

/**
 * JarView Application Klasse.
 * Generiert mit JBuilder 3.5 Foundation
 */
public class JarView {
  boolean packFrame = false;

  //Construct the application
  public JarView(String startDir) {
    JvFrame frame = new JvFrame(startDir);
    //Validate frames that have preset sizes
    //Pack frames that have useful preferred size info, e.g. from their layout
    if (packFrame)
      frame.pack();
    else
      frame.validate();
    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height)
      frameSize.height = screenSize.height;
    if (frameSize.width > screenSize.width)
      frameSize.width = screenSize.width;
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    frame.setVisible(true);
  }

  //Main method
  public static void main(String[] args) {
    try  {
      //UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch(Exception e) {
    }

    // -d Verzeichnis
    String startDir = option(args, "-d", ".");

    new JarView(startDir);
  }

  /**
   * Liefert eine Kommandozeilen-Option zurck
   */
  private static String option(String [] args, String optName, String defaultVal) {
    String opt = optName;
    for(int i=0; i<args.length; i++) {
      if(opt.equals(args[i]))
        return args[++i];
    }
    return defaultVal;
  }
}
