package de.ebuchner.datatransfer;

import java.io.*;
import java.util.*;

import java.awt.datatransfer.*;

/**
 * Dateiliste als Transferable.<p>
 * Die Dateiliste wird im Format List von File-Objekten gespeichert.
 * Welches Format ein OS unterstuetzt, ist in
 * flavormap.properties hinterlegt.
 */
public class FileSelection implements Transferable {

  static final DataFlavor FILE_FLAVORS [] = {DataFlavor.javaFileListFlavor};

  private ArrayList data = new ArrayList();

  /**
   * Defaultkonstruktor. Files koenne mit add() nachtraeglich
   * hinzugefuegt werden
   */
  public FileSelection() {
  }

  /**
   * Nimmt eine Datei
   */
  public FileSelection(File f) {
    data.add(f);
  }

  /**
   * Nimmt ein Array von Dateien
   */
  public FileSelection(File files []) {
    for(int i=0; i<files.length; i++)
      data.add(files[i]);
  }

  /**
   * Nimmt eine Liste von Dateien
   */
  public FileSelection(Collection c) {
    data.addAll(c);
  }

  /**
   * Einzelne Dateien hinzufgen
   */
  public void add(File f) {
    data.add(f);
  }

  /**
   *  Transferable Schnittstelle
   */
  public DataFlavor[] getTransferDataFlavors() {
    return FILE_FLAVORS;
  }

  /**
   * Transferable Schnittstelle
   */
  public boolean isDataFlavorSupported(DataFlavor flavor) {
    for(int i=0; i<FILE_FLAVORS.length; i++) {
      if(FILE_FLAVORS[i].equals(flavor))
        return true;
    }
    return false;
  }

  /**
   * Transferable Schnittstelle
   */
  public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
    if(!isDataFlavorSupported(flavor))
      throw new UnsupportedFlavorException(flavor);

    return data;
  }
}