package de.ebuchner.jar;

import java.io.*;
import java.util.*;
import java.util.jar.*;

/**
 * Einige nuetzliche Methoden fuer den Umgang mit Java Archiven
 */
public final class JarUtils {

  private static String TMPDIR;

  // Unter NT 4 "c:\temp\"
  // Unter Red Hat 6.1 "/tmp"
  static {
    TMPDIR = System.getProperty("java.io.tmpdir");
    if(!TMPDIR.endsWith(File.separator))
      TMPDIR += File.separatorChar;
  }

  /**
   * Zerlegt einen Eintrag in einem JarFile in Strings
   */
  public static Enumeration splitName(JarEntry entry) {
    StringTokenizer tok = new StringTokenizer(entry.getName(), "/");
    return tok;
  }

  /**
   * Trennt den Dateinamen vom Pfad ab
   */
  public static String nameOf(JarEntry entry) {
    Enumeration en = splitName(entry);

    String name = null;
    while(en.hasMoreElements())
      name = (String)en.nextElement();
    return name;
  }

  /**
   * Liefert den Pfad eines Eintrags
   */
  public static String pathOf(JarEntry entry) {
    Enumeration en = splitName(entry);
    StringBuffer path = new StringBuffer();

    while(en.hasMoreElements()) {
      String name = (String)en.nextElement();
      if(en.hasMoreElements()) {
        if(path.length()>0)
          path.append(File.separatorChar);
        path.append(name);
      }
    }
    return path.toString();
  }

  /**
   * Auspacken eines Eintrags im Jar-File ins Temp-Verzeichnis
   */
  public static File extract(JarFile file, JarEntry entry) throws IOException {
    File f = genTmpFile(file, entry);
    return extract(file, entry, f);
  }

  /**
   * Auspacken eines Eintrags im Jar-File in eine bestimmte Datei
   */
  public static File extract(JarFile jarFile, JarEntry entry, File targetFile)
   throws IOException
  {
    // Die Datei auspacken
    InputStream is = null;
    OutputStream os = null;

    try {
      is = jarFile.getInputStream(entry);
      os = new FileOutputStream(targetFile);

      byte [] buf = new byte[1024];
      int len;
      while((len=is.read(buf))>0)
        os.write(buf, 0, len);

      return targetFile;
    } finally {
      if(is!=null) is.close();
      if(os!=null) os.close();
    }
  }

  /**
   * Erzeugt ein File-Objekt, das der auszupackenden Datei entspricht.
   * Ggf. werden Unterverzeichnisse angelegt
   */
  private static File genTmpFile(JarFile jarFile, JarEntry entry) {
    File tmpFile;
    String tmpFileName = nameOf(entry);

    String relPath = pathOf(entry);
    if(relPath.length()>0) {
      StringBuffer absPath = new StringBuffer(TMPDIR)
                                 .append(relPath);
      File tmpDir = new File(absPath.toString());
      if(!tmpDir.exists())
        tmpDir.mkdirs();
      tmpFile = new File(tmpDir, tmpFileName);
    } else
      tmpFile = new File(TMPDIR, tmpFileName);

    tmpFile.deleteOnExit();
    return tmpFile;
  }
}
