package de.ebuchner.je;

import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * Model fuer FileTable. Basiert auf dem Inhalt eines Verzeichnisses
 */
public class FileTableModel extends AbstractTableModel {

  // Current Working Directory
  private Object [] cwd = JeUtils.NO_FILES;

  private String [] colNames = { "Name", "Size", "Modified" };
  private Class [] colClasses = { File.class, Long.class, Date.class };

  public int getRowCount() {
    return cwd.length;
  }

  public int getColumnCount() {
    return colNames.length;
  }

  public String getColumnName(int columnIndex) {
    return colNames[columnIndex];
  }

  public Class getColumnClass(int columnIndex) {
    return colClasses[columnIndex];
  }

  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return false;
  }

  public File getFileAt(int rowIdx) {
    return (File)getValueAt(rowIdx, 0);
  }

  public Object getValueAt(int rowIndex, int columnIndex) {

    File f = (File)cwd[rowIndex];

    try {
      switch(columnIndex) {
        case 0 /*File-Name*/:
          return f;
        case 1 /*Size*/:
            return new Long(f.length());
        case 2 /*Datum*/:
          return new Date(f.lastModified());
      }
      throw new IllegalArgumentException("No such column " + columnIndex);
    } catch(SecurityException se) {
      return null;
    }
  }

  public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    // read-only
  }

  /**
   * In neues Verzeichnis wechseln
   */
  public void setCwd(File dir) {
    File [] files = null;
    if(dir!=null)
      files = dir.listFiles();

    if(files==null)
      files = JeUtils.NO_FILES;
    else
      cwd = JeUtils.extract(files, JeUtils.TYPE_FILES, true /*sort*/, false /*showHidden*/);
    fireTableDataChanged();
  }
}
