package de.ebuchner.jv;

import java.awt.*;
import java.text.*;
import java.util.Date;
import java.util.jar.*;
import javax.swing.*;

/**
 * Ein Panel, das Informationen ber einen Eintrag im Jar File
 * anzeigt
 */
public class JvEntryPanel extends JPanel {

  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JLabel lbSize = new JLabel();
  JTextField tfSize = new JTextField();
  JLabel lbCompressed = new JLabel();
  JTextField tfCompressed = new JTextField();
  JLabel lbTime = new JLabel();
  JTextField tfTime = new JTextField();
  JLabel lbComment = new JLabel();
  JTextArea taComment = new JTextArea();
  JScrollPane scrollPane1 = new JScrollPane();

  DateFormat    dtef = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT);
  DecimalFormat intf = new DecimalFormat("#,##0");
  DecimalFormat prcf = new DecimalFormat("#.0%");

  /**
   * Zeigt Informationen zu einem Eintrag an
   */
  public void show(JarEntry entry) {
    // Groesse
    long size = entry.getSize();
    if(size>0) {
      tfSize.setText(intf.format(size));

      // CompressedSize
      long compressed = entry.getCompressedSize();
      if(compressed==size)
        tfCompressed.setText("(not compressed)");
      else
        tfCompressed.setText(prcf.format((double)compressed/size));
    }
    else {
      tfSize.setText("");
      tfCompressed.setText("");
    }

    // Time
    long time = entry.getTime();
    if (time>0)
      tfTime.setText(dtef.format(new Date(time)));
    else
      tfTime.setText("");

    // Comment
    String comment = entry.getComment();
    if(comment!=null)
      taComment.setText(comment);
    else
      taComment.setText("");
  }

  public JvEntryPanel() {
    try  {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    this.setLayout(gridBagLayout1);
    lbSize.setText("Size:");
    tfSize.setEditable(false);
    tfSize.setColumns(10);
    tfSize.setHorizontalAlignment(SwingConstants.RIGHT);
    lbCompressed.setText("Compressed:");
    tfCompressed.setEditable(false);
    tfCompressed.setColumns(10);
    tfCompressed.setHorizontalAlignment(SwingConstants.RIGHT);
    lbTime.setText("Time:");
    tfTime.setEditable(false);
    tfTime.setColumns(10);
    tfTime.setHorizontalAlignment(SwingConstants.RIGHT);
    lbComment.setText("Comment:");
    taComment.setLineWrap(true);
    taComment.setColumns(30);
    taComment.setRows(2);
    taComment.setEditable(false);
    // Note: Unter KDE (RedHat) muessen die Textfelder auf Fill=Horizontal/Both
    // gesetzt werden, sonst werden sie nicht sichtbar
    this.add(lbSize,       new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 0, 0), 0, 0));
    this.add(tfSize,       new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 0, 5), 0, 0));
    this.add(lbCompressed, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 0, 0), 0, 0));
    this.add(tfCompressed, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 0, 5), 0, 0));
    this.add(lbTime,       new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 0, 0), 0, 0));
    this.add(tfTime,       new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 0, 5), 0, 0));
    this.add(lbComment,    new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(5, 5, 0, 0), 0, 0));
    this.add(scrollPane1,  new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    scrollPane1.getViewport().add(taComment, null);
  }
}
