package de.ebuchner.jv;

import java.util.jar.JarEntry;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Ein TreeKnoten, der einem JarFile-Entry entspricht
 */
class JvTreeNode extends DefaultMutableTreeNode {

  JarEntry entry;

  /**
   * Konstruktor
   */
  public JvTreeNode(JarEntry entry, String name) {
    this.entry = entry;
    this.setUserObject(name);
  }

  /**
   * Konstruktor fuer Knoten, denen kein Element
   * im Jar File entspricht (tritt manchmal auf bei Verzeichnissen)
   */
  public JvTreeNode(String name) {
    this.entry = null;
    this.setUserObject(name);
  }

  /**
   * Welchem Jar-File-Entry entspricht dieser Knoten?
   */
  public JarEntry entry() {
    return entry;
  }
}
