/*
 * Decompiled with CFR 0.152.
 */
package de.ix.jspTutorial.controller;

import de.ix.jspTutorial.constants.SessionConstants;
import de.ix.jspTutorial.model.Customer;
import de.ix.jspTutorial.model.PersonalPizza;
import de.ix.jspTutorial.model.PizzaAccessor;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class ModelManager
implements SessionConstants {
    public static String vcid = "$Id:$";
    private ServletContext myApplication;
    private HttpSession httpSession;

    public Customer getCustomer() {
        Customer customer = (Customer)this.httpSession.getValue("customer");
        if (customer == null) {
            customer = new Customer();
            this.httpSession.putValue("customer", (Object)customer);
        }
        return customer;
    }

    public PersonalPizza getPersonalPizza() {
        PersonalPizza personalPizza = (PersonalPizza)this.httpSession.getValue("personalPizza");
        if (personalPizza == null) {
            personalPizza = new PersonalPizza();
            this.httpSession.putValue("personalPizza", (Object)personalPizza);
        }
        return personalPizza;
    }

    public PizzaAccessor getPizzaAccessor() {
        PizzaAccessor pizzaAccessor = (PizzaAccessor)this.myApplication.getAttribute("pizzaAccessor");
        if (pizzaAccessor == null) {
            pizzaAccessor = new PizzaAccessor(this.myApplication);
            this.myApplication.setAttribute("pizzaAccessor", (Object)pizzaAccessor);
        }
        return pizzaAccessor;
    }

    public void init(ServletContext servletContext, HttpSession httpSession) {
        this.httpSession = httpSession;
        this.myApplication = servletContext;
    }

    public boolean isCustomerLoggedIn() {
        Customer customer = (Customer)this.httpSession.getValue("customer");
        return customer != null;
    }

    public void resetCustomer() {
        this.httpSession.removeValue("customer");
    }

    public void setCustomer(Customer customer) {
        this.httpSession.putValue("customer", (Object)customer);
    }

    public void setPersonalPizza(PersonalPizza personalPizza) {
        this.httpSession.putValue("personalPizza", (Object)personalPizza);
    }
}

