/*
 * Decompiled with CFR 0.152.
 */
package de.ix.jspTutorial.controller;

import de.ix.jspTutorial.constants.RequestParameterConstants;
import de.ix.jspTutorial.controller.ModelManager;
import de.ix.jspTutorial.controller.RequestInfo;
import de.ix.jspTutorial.exception.MissingInputParamsException;
import de.ix.jspTutorial.model.Customer;
import de.ix.jspTutorial.model.PersonalPizza;
import de.ix.jspTutorial.model.PizzaAccessor;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RequestProcessor
implements RequestParameterConstants {
    public static String vcid = "$Id:$";
    private HttpSession httpSession;
    private ServletContext myApplication;
    private ModelManager pizzaModelManager;

    public void checkParameters(String string, HttpServletRequest httpServletRequest) throws MissingInputParamsException {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        RequestInfo requestInfo = new RequestInfo();
        Enumeration enumeration = requestInfo.getParamNames(string);
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (httpServletRequest.getParameter(string2) != null) continue;
            bl = true;
            vector.addElement(string2);
        }
        if (bl) {
            throw new MissingInputParamsException(string, vector);
        }
    }

    public void handleChoiseEvent(HttpServletRequest httpServletRequest) {
        String[] stringArray = httpServletRequest.getParameterValues("ID_INGREDIENTS");
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (n + 1 < stringArray.length) {
                    stringBuffer.append(",");
                }
                ++n;
            }
        }
        String string = httpServletRequest.getParameter("ID_PIZZA");
        this.log("Pizza-ID: " + string);
        this.log("Ingredient-IDs: " + stringArray);
        PersonalPizza personalPizza = new PersonalPizza(httpServletRequest, string, stringBuffer.toString());
        this.pizzaModelManager.setPersonalPizza(personalPizza);
    }

    public void handleEvent(String string, HttpServletRequest httpServletRequest) {
        if (string.equals("logout")) {
            this.handleLogoutEvent(httpServletRequest);
        } else if (string.equals("login")) {
            this.handleLoginEvent(httpServletRequest);
        } else if (!string.equals("showlogin")) {
            if (string.equals("choice")) {
                this.handleChoiseEvent(httpServletRequest);
            } else if (!string.equals("showChoice")) {
                if (string.equals("order")) {
                    this.handleOrderEvent(httpServletRequest);
                } else {
                    new RuntimeException("Wrong Action");
                }
            }
        }
    }

    public void handleLoginEvent(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        PizzaAccessor pizzaAccessor = this.pizzaModelManager.getPizzaAccessor();
        Customer customer = pizzaAccessor.generateCustomer(httpServletRequest);
        if (customer.getId() > 0L) {
            this.log("Check Customer " + customer);
            bl = pizzaAccessor.checkCustomer(customer);
        } else {
            this.log("new Customer " + customer);
            bl = pizzaAccessor.newCustomer(customer);
        }
        this.log("valid Customer " + bl);
        if (bl) {
            this.pizzaModelManager.setCustomer(customer);
        } else {
            this.pizzaModelManager.resetCustomer();
        }
    }

    public void handleLogoutEvent(HttpServletRequest httpServletRequest) {
        this.pizzaModelManager.resetCustomer();
    }

    public void handleOrderEvent(HttpServletRequest httpServletRequest) {
        PizzaAccessor pizzaAccessor = this.pizzaModelManager.getPizzaAccessor();
        PersonalPizza personalPizza = this.pizzaModelManager.getPersonalPizza();
        Customer customer = pizzaAccessor.generateCustomer(httpServletRequest);
        this.pizzaModelManager.setCustomer(customer);
        if (!pizzaAccessor.newOrder(customer, personalPizza)) {
            throw new RuntimeException("Can't save Order - " + customer + " ## " + personalPizza);
        }
    }

    public void init(ServletContext servletContext, HttpSession httpSession) {
        this.httpSession = httpSession;
        this.myApplication = servletContext;
        this.pizzaModelManager = (ModelManager)httpSession.getValue("pizzaModelManager");
    }

    public void log(String string) {
        this.myApplication.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.myApplication.log(string, throwable);
    }

    public void processRequest(HttpServletRequest httpServletRequest) throws MissingInputParamsException {
        String string = "";
        try {
            string = httpServletRequest.getParameter("doAction");
        }
        catch (Exception exception) {
            string = "";
        }
        this.checkParameters(string, httpServletRequest);
        this.handleEvent(string, httpServletRequest);
    }
}

